//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsGradientBackground_c.h, C++ API dsGradientBackground_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsGradientBackground_p;
class dsGradientBackground;
class dsColor_c;
class DSINTERFACE_EXPORT dsGradientBackground_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsGradientBackground)
public:
	DSRESULT IsSame(dsGradientBackground_c* dsObj);

	DSRESULT get_TopColor(dsColor_c  ** Val);
	DSRESULT put_TopColor(dsColor_c  * NewVal);
	DSRESULT get_MiddleColor(dsColor_c  ** Val);
	DSRESULT put_MiddleColor(dsColor_c  * NewVal);
	DSRESULT get_BottomColor(dsColor_c  ** Val);
	DSRESULT put_BottomColor(dsColor_c  * NewVal);
	DSRESULT get_UseTwoColors(bool * Val);
	DSRESULT put_UseTwoColors(bool  NewVal);
	DSRESULT get_Angle(double * Val);
	DSRESULT put_Angle(double  NewVal);
	DSRESULT get_Erased(bool * Val);
	DSRESULT put_Erased(bool  NewVal);
	DSRESULT get_Handle(dsString*  Val);
};
