//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsImageBackground_c.h, C++ API dsImageBackground_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsImageBackground_p;
class dsImageBackground;
class DSINTERFACE_EXPORT dsImageBackground_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsImageBackground)
public:
	DSRESULT IsSame(dsImageBackground_c* dsObj);

	DSRESULT get_FileName(dsString*  Val);
	DSRESULT put_FileName(const dsString&  NewVal);
	DSRESULT get_Position(dsImageBackgroundPosition_e*  Val);
	DSRESULT put_Position(dsImageBackgroundPosition_e  NewVal);
	DSRESULT get_OffsetX(double * Val);
	DSRESULT put_OffsetX(double  NewVal);
	DSRESULT get_OffsetY(double * Val);
	DSRESULT put_OffsetY(double  NewVal);
	DSRESULT get_ScaleX(double * Val);
	DSRESULT put_ScaleX(double  NewVal);
	DSRESULT get_ScaleY(double * Val);
	DSRESULT put_ScaleY(double  NewVal);
	DSRESULT get_Erased(bool * Val);
	DSRESULT put_Erased(bool  NewVal);
	DSRESULT get_Handle(dsString*  Val);
};
