//========================================================================//
//							SOURCE CODE LICENSE							  //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsInterfaceArrayPtr.h, C++ API smart pointer to interface
//

#pragma once
#include "dsObject.h"


template <class T> class dsInterfaceArrayPtr : dsObject
{
public:
	dsInterfaceArrayPtr() { }
	dsInterfaceArrayPtr(dsInterfaceArrayPtr<T>& dsIPtrArray) { dsIPtrArray.processCache(); connectTo(&dsIPtrArray.getDsChildren()); }
    ~dsInterfaceArrayPtr() { clear(); }

	unsigned int getSize() { processCache(); return getDsChildren().getSize(); } 
	void clear() 
	{
		while ( m_dsObjectArrayCache.getSize() > 0 ) delete m_dsObjectArrayCache[0]; 
		while( getDsChildren().getSize() > 0) delete getDsChildren()[0];
	}

	bool removeAt(unsigned int index) { processCache(); return deleteObject(index); }

	T* operator [] (unsigned int index) { processCache(); return (T *) getDsChildren()[index]; }
	dsObjectPtrArray * operator&() { processCache(); return &m_dsObjectArrayCache; }
	dsInterfaceArrayPtr<T>& operator=(dsInterfaceArrayPtr<T>& rhs) {rhs.processCache(); processCache(); connectTo(&rhs.getDsChildren()); return *this; }

private:
	bool deleteObject(unsigned int index)
	{
		if ( index >= getDsChildren().getSize() ) return false;
		delete getDsChildren()[index];
		return true;
	}

	void connectTo(dsObjectPtrArray* toObjArray)
	{
		if ( &getDsChildren() == toObjArray)	return;
		clear();
		for (int ii = 0; ii < toObjArray->getSize(); ii++ )
			addObject((T *) (*toObjArray)[ii]);
	}

	void addObject(T* toObj)
	{
		if ( toObj != NULL )
		{
			T* ObjToAdd = toObj;
			if ( ObjToAdd->getDsParent() != NULL)
				ObjToAdd = new T(toObj);
			ObjToAdd->setDsParent(this);
		}
	}

	void processCache()
	{
		if (  m_dsObjectArrayCache.getSize() == 0 ) return;
		while( getDsChildren().getSize() > 0) delete getDsChildren()[0];
		for (int ii = 0; ii < m_dsObjectArrayCache.getSize(); ii++ )
			addObject((T*) m_dsObjectArrayCache[ii]);
		m_dsObjectArrayCache.clear();
	}

	dsObjectPtrArray m_dsObjectArrayCache;
};


class dsApplication_c;
class dsDocument_c;
class dsModel_c; 
class dsSheet_c;
class dsSelectionManager_c;
class dsBlockDefinition_c;
class dsBlockInstance_c;
class dsAttributeDefinition_c;
class dsExternalReference_c;
class dsAttributeInstance_c;
class dsPrintManager_c;
class dsSketchManager_c;
class dsReferenceImage_c;
class dsDocumentExporter_c;
class dsCommand_c;
class dsUserCommand_c;
class dsMenuItem_c;
class dsToolbar_c;
class dsToolbarItem_c;
class dsCommandMessage_c;

typedef dsInterfaceArrayPtr<dsApplication_c> dsApplicationArray_ptr;
typedef dsInterfaceArrayPtr<dsDocument_c> dsDocumentArray_ptr;
typedef dsInterfaceArrayPtr<dsModel_c> dsModelArray_ptr; 
typedef dsInterfaceArrayPtr<dsSheet_c> dsSheetArray_ptr;
typedef dsInterfaceArrayPtr<dsSelectionManager_c> dsSelectionManagerArray_ptr;
typedef dsInterfaceArrayPtr<dsBlockDefinition_c> dsBlockDefinitionArray_ptr;
typedef dsInterfaceArrayPtr<dsBlockInstance_c> dsBlockInstanceArray_ptr;
typedef dsInterfaceArrayPtr<dsAttributeDefinition_c> dsAttributeDefinitionArray_ptr;
typedef dsInterfaceArrayPtr<dsExternalReference_c> dsExternalReferenceArray_ptr;
typedef dsInterfaceArrayPtr<dsAttributeInstance_c> dsAttributeInstanceArray_ptr;
typedef dsInterfaceArrayPtr<dsPrintManager_c> dsPrintManagerArray_ptr;
typedef dsInterfaceArrayPtr<dsSketchManager_c> dsSketchManagerArray_ptr;
typedef dsInterfaceArrayPtr<dsReferenceImage_c> dsReferenceImageArray_ptr;
typedef dsInterfaceArrayPtr<dsDocumentExporter_c> dsDocumentExporterArray_ptr;
typedef dsInterfaceArrayPtr<dsCommand_c> dsCommandArray_ptr;
typedef dsInterfaceArrayPtr<dsUserCommand_c> dsUserCommandArray_ptr;
typedef dsInterfaceArrayPtr<dsMenuItem_c> dsMenuItemArray_ptr;
typedef dsInterfaceArrayPtr<dsToolbar_c> dsToolbarArray_ptr;
typedef dsInterfaceArrayPtr<dsToolbarItem_c> dsToolbarItemArray_ptr;
typedef dsInterfaceArrayPtr<dsCommandMessage_c> dsCommandMessageArray_ptr;