//========================================================================//
//							SOURCE CODE LICENSE							  //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsInterfacePtr.h, C++ API smart pointer to interface
//

#pragma once
#include "dsObject.h"
#include "dsTableStyleManager_c.h"
#include "dsTableStyle_c.h"
#include "dsColor_c.h"
#include "dsDSWindow_c.h"
#include "dsCircle_c.h"
#include "dsModel_c.h"
#include "dsSketchManager_c.h"
#include "dsLine_c.h"
#include "dsTextStyleManager_c.h"
#include "dsTextStyle_c.h"
#include "dsLayerManager_c.h"
#include "dsLayer_c.h"
#include "dsEntityHelper_c.h"
#include "dsCustomData_c.h"
#include "dsHatchBoundaryLoop_c.h"
#include "dsHatchPattern_c.h"
#include "dsGeneralDimension_c.h"
#include "dsAlignedDimension_c.h"
#include "dsDimensionStyleManager_c.h"
#include "dsDimensionStyle_c.h"
#include "dsPolyLine_c.h"
#include "dsDimensionStyle_c.h"
#include "dsDimensionStyleArrowsOptions_c.h"
#include "dsDimensionStyleDualDimensionOptions_c.h"
#include "dsDimensionStyleFitOptions_c.h"
#include "dsDimensionStyleLinearDimensionOptions_c.h"
#include "dsDimensionStyleToleranceOptions_c.h"
#include "dsDimensionStyleTextOptions_c.h"
#include "dsDimensionStyleAngularDimensionOptions_c.h"
#include "dsDimensionStyleRadialDiameterDimensionOptions_c.h"
#include "dsDimensionStyleLineOptions_c.h"
#include "dsHyperLink_c.h"
#include "dsSelectionManager_c.h"
#include "dsMathUtility_c.h"
#include "dsMathVector_c.h"
#include "dsAngularDimension_c.h"
#include "dsReferenceImage_c.h"
#include "dsArcLengthDimension_c.h"
#include "dsDiameterDimension_c.h"
#include "dsDocument_c.h"
#include "dsJoggedDimension_c.h"
#include "dsRotatedDimension_c.h"
#include "dsOrdinateDimension_c.h"
#include "dsRadialDimension_c.h"
#include "dsCustomCoordinateSystemManager_c.h"
#include "dsCustomCoordinateSystem_c.h"
#include "dsAttributeDefinition_c.h"
#include "dsEllipseArc_c.h"
#include "dsMathPoint_c.h"
#include "dsCircleArc_c.h"
#include "dsBlockDefinition_c.h"
#include "dsBlockInstance_c.h"
#include "dsMathPlane_c.h"
#include "dsMathTransform_c.h"
#include "dsMathPoint_c.h"
#include "dsMathLine_c.h"
#include "dsPoint_c.h"
#include "dsInfiniteLine_c.h"
#include "dsNote_c.h"
#include "dsRay_c.h"
#include "dsSystemFiles_c.h"
#include "dsTolerance_c.h"
#include "dsToolbarItem_c.h"
#include "dsTracker_c.h"
#include "dsRichLineStyleManager_c.h"
#include "dsRichLineStyle_c.h"
#include "dsLineStyleManager_c.h"
#include "dsLineStyle_c.h"
#include "dsShapeManager_c.h"
#include "dsShape_c.h"
#include "dsLispFunction_c.h"
#include "dsLispParameter_c.h"
#include "dsSheetNamedView_c.h"
#include "dsModelNamedView_c.h"
#include "dsViewManager_c.h"
#include "dsNamedView_c.h"
#include "dsDimensionStyleUserData_c.h"
#include "dsViewport_c.h"
#include "dsTable_c.h"
#include "dsSpline_c.h"
#include "dsSolid_c.h"
#include "dsRegion_c.h"
#include "dsRichLine_c.h"
#include "dsSimpleNote_c.h"
#include "dsPolyLine3D_c.h"
#include "dsPolygonMesh_c.h"
#include "dsPolyFaceMesh_c.h"
#include "dsLeader_c.h"
#include "dsHatch_c.h"
#include "dsFace_c.h"
#include "dsEmbeddedObject_c.h"
#include "dsTrace_c.h"
#include "dsMacroManager_c.h"
#include "dsGroup_c.h"
#include "dsSolidBackground_c.h"
#include "dsGradientBackground_c.h"
#include "dsImageBackground_c.h"
#include "dsApplicationOptions_c.h"
#include "dsInterfaceFiles_c.h"
#include "dsDrawingSupportFiles_c.h"
#include "dsAttributeInstance_c.h"
#include "dsTransparency_c.h"
#include "dsViewTile_c.h"
#include "dsWorkspace_c.h"
#include "dsRibbonQuickAccessBar_c.h"
#include "dsRibbonQuickAccessBarItem_c.h"
#include "dsRibbonSystemMenu_c.h"
#include "dsRibbonSystemMenuItem_c.h"
#include "dsRibbonTab_c.h"
#include "dsRibbonPanel_c.h"
#include "dsRibbonCommandButton_c.h"
#include "dsRibbonRow_c.h"
#include "dsRibbonRowItem_c.h"
#include "dsRibbonRowPanel_c.h"
#include "dsRibbonSeparator_c.h"
#include "dsRibbonSplitButton_c.h"
#include "dsArcAlignedText_c.h"
#include "dsCurvedSettings_c.h"
#include "dsUnknownEntity_c.h"

template <class T> class dsInterfacePtr : dsObject
{
public:
	dsInterfacePtr(T *dsObj = 0) : m_dsIPtrCache(dsObj) { connectTo(dsObj); }

	dsInterfacePtr(dsInterfacePtr<T> &dsIPtr) : m_dsIPtrCache(dsIPtr.m_dsIPtrCache) {
        dsIPtr.processCache();
        connectTo( (T*)dsIPtr);
    }

    ~dsInterfacePtr() {
        processCache();
    }

	operator T*() {
        processCache();
        return getConnectedObject();
    }

    T **operator&() {
        processCache();
        return &m_dsIPtrCache;
    }

    T *operator->() {
        processCache();
        return getConnectedObject();
    }

    dsInterfacePtr<T>& operator=(dsInterfacePtr<T> &rhs) {
        rhs.processCache();
        m_dsIPtrCache = rhs.m_dsIPtrCache;
        processCache();
        connectTo(rhs);
        return *this;
    }

    bool operator==(T *objOther) {
        processCache();
        T *objMe = getConnectedObject();
        if ( !objMe ) {
            if ( !objOther )
                return true;
            else
                return false;
        }
        return objMe->IsSame(objOther) == DSRESULT_True; 
	}

    bool operator!=(T *objOther) { return !operator==(objOther); }

private:
    void connectTo(T* toObj) {
        T *connectedObj = getConnectedObject();
        if ( connectedObj == toObj )
            return;
        if ( connectedObj )
            delete connectedObj;
        if ( toObj ) {
            T *ObjToAdd = toObj;
            if ( toObj->getDsParent() )
            {
	            ObjToAdd = new T(toObj);
                m_dsIPtrCache = ObjToAdd;
            }
            ObjToAdd->setDsParent(this);
        }
	}

    T *getConnectedObject() {
		T *retVal = 0;
		dsObjectPtrArray& ptrArray = getDsChildren();
		if ( ptrArray.getSize() > 0 )
            retVal = (T*)ptrArray[0];
		return retVal;
	}

	void processCache()	{
            connectTo(m_dsIPtrCache);
	}

	T *m_dsIPtrCache;
};


class dsApplication_c;
class dsDocument_c;
class dsModel_c; 
class dsSheet_c;
class dsSelectionManager_c;
class dsBlockDefinition_c;
class dsBlockInstance_c;
class dsAttributeDefinition_c;
class dsExternalReference_c;
class dsAttributeInstance_c;
class dsPrintManager_c;
class dsSketchManager_c;
class dsReferenceImage_c;
class dsDocumentExporter_c;
class dsCommand_c;
class dsUserCommand_c;
class dsMenuItem_c;
class dsToolbar_c;
class dsToolbarItem_c;
class dsCommandMessage_c;
class dsDSWindow_c;
class dsTableStyleManager_c;
class dsTableStyle_c;
class dsColor_c;
class dsDSWindow_c;
class dsCircle_c;
class dsCircleArc_c;
class dsTextStyleManager_c;
class dsTextStyle_c;
class dsLayerManager_c;
class dsLayer_c;
class dsEllipseArc_c;
class dsEmbeddedObject_c;
class dsEntityHelper_c;
class dsCustomData_c;
class dsFace_c;
class dsHatch_c;
class dsHatchBoundaryLoop_c;
class dsHatchPattern_c;	
class dsInfiniteLine_c;
class dsGeneralDimension_c;
class dsAlignedDimension_c;
class dsDimensionStyleManager_c;
class dsDimensionStyle_c;
class dsLeader_c;
class dsLine_c;
class dsPolyFaceMesh_c;
class dsNote_c;
class dsPoint_c;
class dsPolygonMesh_c;
class dsPolyLine_c;
class dsRay_c;
class dsPolyLine3D_c;
class dsPolygonMesh_c;
class dsNoteWithParameters_c;
class dsDimensionStyle_c;
class dsDimensionStyleArrowsOptions_c;
class dsDimensionStyleDualDimensionOptions_c;
class dsDimensionStyleFitOptions_c;
class dsDimensionStyleLinearDimensionOptions_c;
class dsDimensionStyleToleranceOptions_c;
class dsDimensionStyleTextOptions_c;
class dsDimensionStyleAngularDimensionOptions_c;
class dsDimensionStyleRadialDiameterDimensionOptions_c;
class dsDimensionStyleLineOptions_c;
class dsHyperLink_c;
class dsMathUtility_c;
class dsMathVector_c;
class dsAngularDimension_c;
class dsReferenceImage_c;
class dsArcLengthDimension_c;
class dsDiameterDimension_c;
class dsJoggedDimension_c;
class dsSolid_c;
class dsSpline_c;
class dsRotatedDimension_c;
class dsOrdinateDimension_c;
class dsTolerance_c;
class dsRichLine_c;
class dsLine_c;
class dsRadialDimension_c;
class dsCustomCoordinateSystemManager_c;
class dsCustomCoordinateSystem_c;
class dsSimpleNote_c;
class dsNormal_c;
class dsMathPoint_c;
class dsMathPlane_c;
class dsMathTransform_c;
class dsMathLine_c;
class dsInfiniteLine_c;
class dsNote_c;
class dsPoint_c;
class dsSystemFiles_c;
class dsMathCircArc_c;
class dsMathEllipArc_c;
class dsDrawingSupportFiles_c;
class dsInterfaceFiles_c;
class dsTrace_c;
class dsTestMacroManager_c;

typedef dsInterfacePtr<dsApplication_c> dsApplication_ptr;
typedef dsInterfacePtr<dsDocument_c> dsDocument_ptr;
typedef dsInterfacePtr<dsModel_c> dsModel_ptr; 
typedef dsInterfacePtr<dsSheet_c> dsSheet_ptr;
typedef dsInterfacePtr<dsSelectionManager_c> dsSelectionManager_ptr;
typedef dsInterfacePtr<dsBlockDefinition_c> dsBlockDefinition_ptr;
typedef dsInterfacePtr<dsBlockInstance_c> dsBlockInstance_ptr;
typedef dsInterfacePtr<dsAttributeDefinition_c> dsAttributeDefinition_ptr;
typedef dsInterfacePtr<dsExternalReference_c> dsExternalReference_ptr;
typedef dsInterfacePtr<dsAttributeInstance_c> dsAttributeInstance_ptr;
typedef dsInterfacePtr<dsPrintManager_c> dsPrintManager_ptr;
typedef dsInterfacePtr<dsSketchManager_c> dsSketchManager_ptr;
typedef dsInterfacePtr<dsReferenceImage_c> dsReferenceImage_ptr;
typedef dsInterfacePtr<dsDocumentExporter_c> dsDocumentExporter_ptr;
typedef dsInterfacePtr<dsCommand_c> dsCommand_ptr;
typedef dsInterfacePtr<dsUserCommand_c> dsUserCommand_ptr;
typedef dsInterfacePtr<dsMenuItem_c> dsMenuItem_ptr;
typedef dsInterfacePtr<dsToolbar_c> dsToolbar_ptr;
typedef dsInterfacePtr<dsToolbarItem_c> dsToolbarItem_ptr;
typedef dsInterfacePtr<dsCommandMessage_c> dsCommandMessage_ptr;
typedef dsInterfacePtr<dsDSWindow_c> dsDSWindow_ptr;
typedef dsInterfacePtr<dsTableStyleManager_c> dsTableStyleManager_ptr;
typedef dsInterfacePtr<dsTableStyle_c> dsTableStyle_ptr;
typedef dsInterfacePtr<dsColor_c> dsColor_ptr;
typedef dsInterfacePtr<dsDSWindow_c> dsDSWindow_ptr;
typedef dsInterfacePtr<dsCircleArc_c> dsCircleArc_ptr;
typedef dsInterfacePtr<dsCircle_c> dsCircle_ptr;
typedef dsInterfacePtr<dsModel_c> dsModel_ptr;
typedef dsInterfacePtr<dsTextStyleManager_c> dsTextStyleManager_ptr;
typedef dsInterfacePtr<dsTextStyle_c> dsTextStyle_ptr;
typedef dsInterfacePtr<dsLayerManager_c> dsLayerManager_ptr;
typedef dsInterfacePtr<dsLayer_c> dsLayer_ptr;
typedef dsInterfacePtr<dsEllipseArc_c> dsEllipseArc_ptr;
typedef dsInterfacePtr<dsEmbeddedObject_c> dsEmbeddedObject_ptr;
typedef dsInterfacePtr<dsEntityHelper_c> dsEntityHelper_ptr;
typedef dsInterfacePtr<dsCustomData_c> dsCustomData_ptr;
typedef dsInterfacePtr<dsFace_c> dsFace_ptr;
typedef dsInterfacePtr<dsHatch_c> dsHatch_ptr;
typedef dsInterfacePtr<dsHatchBoundaryLoop_c> dsHatchBoundaryLoop_ptr;
typedef dsInterfacePtr<dsHatchPattern_c> dsHatchPattern_ptr;
typedef dsInterfacePtr<dsInfiniteLine_c> dsInfiniteLine_ptr;
typedef dsInterfacePtr<dsGeneralDimension_c> dsGeneralDimension_ptr;
typedef dsInterfacePtr<dsAlignedDimension_c> dsAlignedDimension_ptr;
typedef dsInterfacePtr<dsDimensionStyleManager_c> dsDimensionStyleManager_ptr;
typedef dsInterfacePtr<dsDimensionStyle_c> dsDimensionStyle_ptr;
typedef dsInterfacePtr<dsInfiniteLine_c> dsInfiniteLine_ptr;
typedef dsInterfacePtr<dsLeader_c> dsLeader_ptr;
typedef dsInterfacePtr<dsLine_c> dsLine_ptr;
typedef dsInterfacePtr<dsPolyFaceMesh_c> dsPolyFaceMesh_ptr;
typedef dsInterfacePtr<dsPolyLine_c> dsPolyLine_ptr;
typedef dsInterfacePtr<dsPolygonMesh_c> dsPolygonMesh_ptr;
typedef dsInterfacePtr<dsNoteWithParameters_c> dsNoteWithParameters_ptr;
typedef dsInterfacePtr<dsRay_c> dsRay_ptr;
typedef dsInterfacePtr<dsPolyLine3D_c> dsPolyLine3D_ptr;
typedef dsInterfacePtr<dsPolygonMesh_c> dsPolygonMesh_ptr;
typedef dsInterfacePtr<dsNote_c> dsNote_ptr;
typedef dsInterfacePtr<dsPoint_c> dsPoint_ptr;
typedef dsInterfacePtr<dsDimensionStyle_c> dsDimensionStyle_ptr; 
typedef dsInterfacePtr<dsDimensionStyleArrowsOptions_c> dsDimensionStyleArrowsOptions_ptr;
typedef dsInterfacePtr<dsDimensionStyleDualDimensionOptions_c> dsDimensionStyleDualDimensionOptions_ptr;
typedef dsInterfacePtr<dsDimensionStyleFitOptions_c> dsDimensionStyleFitOptions_ptr;
typedef dsInterfacePtr<dsDimensionStyleLinearDimensionOptions_c> dsDimensionStyleLinearDimensionOptions_ptr;
typedef dsInterfacePtr<dsDimensionStyleToleranceOptions_c> dsDimensionStyleToleranceOptions_ptr;
typedef dsInterfacePtr<dsDimensionStyleTextOptions_c> dsDimensionStyleTextOptions_ptr;
typedef dsInterfacePtr<dsDimensionStyleAngularDimensionOptions_c>dsDimensionStyleAngularDimensionOptions_ptr;
typedef dsInterfacePtr<dsDimensionStyleRadialDiameterDimensionOptions_c>dsDimensionStyleRadialDiameterDimensionOptions_ptr;
typedef dsInterfacePtr<dsDimensionStyleLineOptions_c> dsDimensionStyleLineOptions_ptr;
typedef dsInterfacePtr<dsHyperLink_c> dsHyperLink_ptr;
typedef dsInterfacePtr<dsMathUtility_c> dsMathUtility_ptr;
typedef dsInterfacePtr<dsMathVector_c> dsMathVector_ptr;
typedef dsInterfacePtr<dsReferenceImage_c> dsReferenceImage_ptr;
typedef dsInterfacePtr<dsAngularDimension_c> dsAngularDimension_ptr;
typedef dsInterfacePtr<dsDiameterDimension_c> dsDiameterDimension_ptr;
typedef dsInterfacePtr<dsJoggedDimension_c> dsJoggedDimension_ptr;
typedef dsInterfacePtr<dsArcLengthDimension_c> dsArcLengthDimension_ptr;
typedef dsInterfacePtr<dsSolid_c> dsSolid_ptr;
typedef dsInterfacePtr<dsSpline_c> dsSpline_ptr;
typedef dsInterfacePtr<dsRotatedDimension_c> dsRotatedDimension_ptr;
typedef dsInterfacePtr<dsOrdinateDimension_c> dsOrdinateDimension_ptr;
typedef dsInterfacePtr<dsTolerance_c> dsTolerance_ptr;
typedef dsInterfacePtr<dsRichLine_c> dsRichLine_ptr;
typedef dsInterfacePtr<dsRadialDimension_c> dsRadialDimension_ptr;
typedef dsInterfacePtr<dsCustomCoordinateSystemManager_c> dsCustomCoordinateSystemManager_ptr;
typedef dsInterfacePtr<dsCustomCoordinateSystem_c> dsCustomCoordinateSystem_ptr;
typedef dsInterfacePtr<dsSimpleNote_c> dsSimpleNote_ptr;
typedef dsInterfacePtr<dsNormal_c> dsNormal_ptr;
typedef dsInterfacePtr<dsMathPoint_c> dsMathPoint_ptr;
typedef dsInterfacePtr<dsMathPlane_c> dsMathPlane_ptr; 
typedef dsInterfacePtr<dsMathTransform_c> dsMathTransform_ptr;
typedef dsInterfacePtr<dsMathLine_c> dsMathLine_ptr;
typedef dsInterfacePtr<dsMathPoint_c> dsMathPoint_ptr;
typedef dsInterfacePtr<dsInfiniteLine_c> dsInfiniteLine_ptr;
typedef dsInterfacePtr<dsNote_c> dsNote_ptr;
typedef dsInterfacePtr<dsPoint_c> dsPoint_ptr;
typedef dsInterfacePtr<dsSystemFiles_c> dsSystemFiles_ptr;
typedef dsInterfacePtr<dsTolerance_c> dsTolerance_ptr;
typedef dsInterfacePtr<dsTracker_c> dsTracker_ptr;
typedef dsInterfacePtr<dsRichLineStyleManager_c> dsRichLineStyleManager_ptr;
typedef dsInterfacePtr<dsRichLineStyle_c> dsRichLineStyle_ptr;
typedef dsInterfacePtr<dsLineStyleManager_c> dsLineStyleManager_ptr;
typedef dsInterfacePtr<dsLineStyle_c> dsLineStyle_ptr;
typedef dsInterfacePtr<dsShapeManager_c> dsShapeManager_ptr;
typedef dsInterfacePtr<dsShape_c> dsShape_ptr;
typedef dsInterfacePtr<dsLispFunction_c> dsLispFunction_ptr;
typedef dsInterfacePtr<dsLispParameter_c> dsLispParameter_ptr;
typedef dsInterfacePtr<dsDimensionStyleUserData_c> dsDimensionStyleUserData_ptr;
typedef dsInterfacePtr<dsViewport_c> dsViewport_ptr;
typedef dsInterfacePtr<dsTable_c> dsTable_ptr;
typedef dsInterfacePtr<dsRegion_c> dsRegion_ptr;
typedef dsInterfacePtr<dsMathCircArc_c> dsMathCircArc_ptr;
typedef dsInterfacePtr<dsMathEllipArc_c> dsMathEllipArc_ptr;
typedef dsInterfacePtr<dsModelNamedView_c> dsModelNamedView_ptr;
typedef dsInterfacePtr<dsSheetNamedView_c> dsSheetNamedView_ptr;
typedef dsInterfacePtr<dsViewManager_c> dsViewManager_ptr;
typedef dsInterfacePtr<dsNamedView_c> dsNamedView_ptr;
typedef dsInterfacePtr<dsDrawingSupportFiles_c> dsDrawingSupportFiles_ptr;
typedef dsInterfacePtr<dsInterfaceFiles_c> dsInterfaceFiles_ptr;
typedef dsInterfacePtr<dsTrace_c> dsTrace_ptr;
typedef dsInterfacePtr<dsMacroManager_c> dsMacroManager_ptr;
typedef dsInterfacePtr<dsGroup_c> dsGroup_ptr;
typedef dsInterfacePtr<dsSolidBackground_c> dsSolidBackground_ptr;
typedef dsInterfacePtr<dsGradientBackground_c> dsGradientBackground_ptr;
typedef dsInterfacePtr<dsImageBackground_c> dsImageBackground_ptr;
typedef dsInterfacePtr<dsApplicationOptions_c> dsApplicationOptions_ptr;
typedef dsInterfacePtr<dsTransparency_c> dsTransparency_ptr;
typedef dsInterfacePtr<dsViewTile_c> dsViewTile_ptr;
typedef dsInterfacePtr<dsWorkspace_c> dsWorkspace_ptr;
typedef dsInterfacePtr<dsRibbonQuickAccessBar_c> dsRibbonQuickAccessBar_ptr;
typedef dsInterfacePtr<dsRibbonQuickAccessBarItem_c> dsRibbonQuickAccessBarItem_ptr;
typedef dsInterfacePtr<dsRibbonSystemMenu_c> dsRibbonSystemMenu_ptr;
typedef dsInterfacePtr<dsRibbonSystemMenuItem_c> dsRibbonSystemMenuItem_ptr;
typedef dsInterfacePtr<dsRibbonTab_c> dsRibbonTab_ptr;
typedef dsInterfacePtr<dsRibbonPanel_c> dsRibbonPanel_ptr;
typedef dsInterfacePtr<dsRibbonCommandButton_c> dsRibbonCommandButton_ptr;
typedef dsInterfacePtr<dsRibbonRow_c> dsRibbonRow_ptr;
typedef dsInterfacePtr<dsRibbonRowItem_c> dsRibbonRowItem_ptr;
typedef dsInterfacePtr<dsRibbonRowPanel_c> dsRibbonRowPanel_ptr;
typedef dsInterfacePtr<dsRibbonSeparator_c> dsRibbonSeparator_ptr;
typedef dsInterfacePtr<dsRibbonSplitButton_c> dsRibbonSplitButton_ptr;
typedef dsInterfacePtr<dsArcAlignedText_c> dsArcAlignedText_ptr;
typedef dsInterfacePtr<dsCurvedSettings_c> dsCurvedSettings_ptr;
typedef dsInterfacePtr<dsUnknownEntity_c> dsUnknownEntity_ptr;
