//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsLayerProperties_c.h, C++ API dsLayerProperties_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"
#include "dsColor_c.h"

class dsLayerProperties_p;
class dsLayerProperties;
class DSINTERFACE_EXPORT dsLayerProperties_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsLayerProperties)
public:
	DSRESULT IsSame(dsLayerProperties_c* dsObj);

	DSRESULT get_Status(bool * Val);
	DSRESULT put_Status(bool  NewVal);
	DSRESULT get_Name(dsString*  Val);
	DSRESULT get_Show(bool * Val);
	DSRESULT put_Show(bool  NewVal);
	DSRESULT get_Frozen(bool * Val);
	DSRESULT put_Frozen(bool  NewVal);
	DSRESULT get_Locked(bool * Val);
	DSRESULT put_Locked(bool  NewVal);
	DSRESULT get_LineColor(dsColor_c ** Val);
	DSRESULT put_LineColor(dsColor_c * NewVal);
	DSRESULT get_LineStyle(dsString*  Val);
	DSRESULT put_LineStyle(const dsString&  NewVal);
	DSRESULT get_LineWeight(dsLineWeight_e*  Val);
	DSRESULT put_LineWeight(dsLineWeight_e  NewVal);
	DSRESULT get_Transparency(long* Val);
	DSRESULT put_Transparency(long NewVal);
	DSRESULT get_PrintStyle(dsString*  Val);
	DSRESULT put_PrintStyle(const dsString&  NewVal);
	DSRESULT get_Print(bool * Val);
	DSRESULT put_Print(bool  NewVal);
	DSRESULT get_FrozenInNewViewPort(bool * Val);
	DSRESULT put_FrozenInNewViewPort(bool  NewVal);
};
