//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsLayerState_c.h, C++ API dsLayerState_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsLayerProperties_c.h"

class dsLayerState_p;
class dsLayerState;
class DSINTERFACE_EXPORT dsLayerState_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsLayerState)
public:
	DSRESULT IsSame(dsLayerState_c* dsObj);

	DSRESULT Activate( );
	DSRESULT AddLayer(const dsString&  LayerName);
	DSRESULT RemoveLayer(const dsString&  LayerName);
	DSRESULT GetLayers(dsObjectPtrArray * LayerArray);
	DSRESULT GetLayerProperties(const dsString&  LayerName, dsLayerProperties_c ** LayerProperties);
	DSRESULT get_Name(dsString*  Val);
	DSRESULT put_Name(const dsString&  NewVal);
	DSRESULT get_Description(dsString*  Val);
	DSRESULT put_Description(const dsString&  NewVal);
	DSRESULT get_Space(dsLayerStateSpaceType_e*  Val);
	DSRESULT get_ShowHide(bool * Val);
	DSRESULT put_ShowHide(bool  NewVal);
	DSRESULT get_FrozenThawed(bool * Val);
	DSRESULT put_FrozenThawed(bool  NewVal);
	DSRESULT get_LockedUnlocked(bool * Val);
	DSRESULT put_LockedUnlocked(bool  NewVal);
	DSRESULT get_LineColor(bool * Val);
	DSRESULT put_LineColor(bool  NewVal);
	DSRESULT get_LineStyle(bool * Val);
	DSRESULT put_LineStyle(bool  NewVal);
	DSRESULT get_PrintStyle(bool * Val);
	DSRESULT put_PrintStyle(bool  NewVal);
	DSRESULT get_Transparency(bool * Val);
	DSRESULT put_Transparency(bool  NewVal);
	DSRESULT get_PrintNoPrint(bool * Val);
	DSRESULT put_PrintNoPrint(bool  NewVal);
	DSRESULT get_NewViewPortFrozenThawed(bool * Val);
	DSRESULT put_NewViewPortFrozenThawed(bool  NewVal);
	DSRESULT get_ActiveViewPortVisibility(bool * Val);
	DSRESULT put_ActiveViewPortVisibility(bool  NewVal);
	DSRESULT get_LineWeight(bool * Val);
	DSRESULT put_LineWeight(bool  NewVal);
};
