//========================================================================//
//							SOURCE CODE LICENSE							  //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsLongArray.h, C++ API dsLongArray interface
//
#pragma once

#include "dsLibrary_global.h"

class dsLongArray_pimpl;
class DSLIBRARY_EXPORT dsLongArray
{
public:
    dsLongArray(); // constructor 
    dsLongArray(const dsLongArray &a); // copy constructor 
    ~dsLongArray(); // distructor 
    dsLongArray& operator = (const dsLongArray &a); // assignment operator 
 
    long& operator [] (unsigned int index) const; // get array item 
    void add(const long &item); // Add item to the end of array 
 
    unsigned int getSize() const; // get size of array (DTements)
    void setSize(unsigned int newsize); // set size of array (DTements)
    void clear(); // clear array
    bool removeAt(unsigned int pos); // delete array item 
	void* getptr(); // get void* pointer to array data
 
    enum exception { MEMFAIL, WRONG_INDEX  }; // exception enum 
 
private:
    dsLongArray_pimpl *m_pimpl;    
};
