//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsMathInfiniteLine_c.h, C++ API dsMathInfiniteLine_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsMathInfiniteLine_p;
class dsMathInfiniteLine;
class dsMathTransform_c;
class dsMathPlane_c;
class dsMathPoint_c;
class dsMathVector_c;
class DSINTERFACE_EXPORT dsMathInfiniteLine_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsMathInfiniteLine)
public:
	DSRESULT IsSame(dsMathInfiniteLine_c* dsObj);
	
	DSRESULT GetPointOnLine(dsMathPoint_c** Point);
	DSRESULT GetDirection(dsMathVector_c** Vector);
	DSRESULT SetPointsOnLine(dsMathPoint_c* Point1, dsMathPoint_c* Point2);
	DSRESULT SetPointAndDirection(dsMathPoint_c* Point, dsMathVector_c* Vector);
	DSRESULT IsParallelToLine(dsObject * Line, double  Tolerance , bool * Result);
	DSRESULT IsParallelToPlane(dsMathPlane_c * Plane, double  Tolerance , bool * Result);
	DSRESULT IsPerpendicularToLine(dsObject * Line, double  Tolerance , bool * Result);
	DSRESULT IsPerpendicularToPlane(dsMathPlane_c * Plane, double  Tolerance , bool * Result);
	DSRESULT TransformBy(dsMathTransform_c * Transform);
	DSRESULT GetClosestPointTo(dsObject * OtherObject, dsMathPoint_c ** ResultPoint);
	DSRESULT IntersectWithLinearObject(dsObject * LinearObject, dsMathPoint_c ** IntersectionPoint);
	DSRESULT IntersectWithPlane(dsMathPlane_c * Plane, dsMathPoint_c ** IntersectionPoint);
};
