//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsMathLine_c.h, C++ API dsMathLine_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsMathLine_p;
class dsMathLine;
class dsMathTransform_c;
class dsMathPlane_c;
class dsMathPoint_c;
class dsMathVector_c;
class dsMathCircArc_c;
class dsMathEllipArc_c;

class DSINTERFACE_EXPORT dsMathLine_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsMathLine)
public:
	DSRESULT IsSame(dsMathLine_c* dsObj);

	DSRESULT get_StartPoint(dsMathPoint_c** Val);
	DSRESULT put_StartPoint(dsMathPoint_c* NewVal);
	DSRESULT get_EndPoint(dsMathPoint_c** Val);
	DSRESULT put_EndPoint(dsMathPoint_c* NewVal);
	DSRESULT GetType(dsMathLineType_e* Val);
	DSRESULT GetDirection(dsMathVector_c** Vector);
	DSRESULT GetLength(double * Length);
	DSRESULT IsParallelToLine(dsMathLine_c * Line, double  Tolerance , bool * Result);
	DSRESULT IsPerpendicularToLine(dsMathLine_c * Line, double  Tolerance , bool * Result);
	DSRESULT TransformBy(dsMathTransform_c * Transform);
	DSRESULT IntersectWithLinearObject(dsMathLine_c * LinearObject, dsMathPoint_c ** IntersectionPoint);
	DSRESULT IntersectWithPlane(dsMathPlane_c * Plane, dsMathPoint_c ** IntersectionPoint);
	DSRESULT GetClosestPointTo(dsMathPoint_c * Point, dsMathPoint_c ** ClosestPoint);
	DSRESULT GetClosestPointToLinearObject(dsMathLine_c * LinearObject , dsMathPoint_c ** PointOnLinearObject , dsMathPoint_c ** ClosestPoint);
	DSRESULT GetClosestPointToCircArc(dsMathCircArc_c * CircArcObject , dsMathPoint_c ** PointOnCircArcObject , dsMathPoint_c ** ClosestPoint);
	DSRESULT GetClosestPointToEllipArc(dsMathEllipArc_c * EllipArcObject , dsMathPoint_c ** PointOnEllipArcObject , dsMathPoint_c ** ClosestPoint);
};
