//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsMathPlane_c.h, C++ API dsMathPlane_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsMathPlane_p;
class dsMathPlane;
class dsMathTransform_c;
class dsMathVector_c;
class dsMathPoint_c;
class dsMathLine_c;
class DSINTERFACE_EXPORT dsMathPlane_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsMathPlane)
public:
	DSRESULT IsSame(dsMathPlane_c* dsObj);

	DSRESULT GetOrigin(dsMathPoint_c ** Point);
	DSRESULT GetNormal(dsMathVector_c ** Normal);
	DSRESULT TransformBy(dsMathTransform_c * Transform);
	DSRESULT IsCoplanarTo(dsMathPlane_c * Plane, double  Tolerance , bool * Result);
	DSRESULT IsParallelTo(dsMathPlane_c * Plane, double  Tolerance , bool * Result);
	DSRESULT IsPerpendicularTo(dsMathPlane_c * Plane, double  Tolerance , bool * Result);
	DSRESULT ReverseNormal( );
	DSRESULT IntersectWithLinearObject(dsMathLine_c * LinearObject, dsMathPoint_c ** IntersectionPoint);
	DSRESULT IntersectWithPlane(dsMathPlane_c * Plane, dsMathLine_c ** IntersectionLine);
	DSRESULT SetOrigin(dsMathPoint_c * Point);
	DSRESULT SetNormal(dsMathVector_c * Normal);
	DSRESULT GetClosestPointTo(dsMathPoint_c * Point, dsMathPoint_c ** ClosestPoint);
};
