//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsMathUtility_c.h, C++ API dsMathUtility_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsDoubleArray.h"

class dsMathUtility_p;
class dsMathUtility;
class dsMathTransform_c;
class dsMathPoint_c;
class dsMathLine_c;
class dsMathVector_c;
class dsMathPlane_c;
class dsMathCircArc_c;
class dsMathEllipArc_c;

class DSINTERFACE_EXPORT dsMathUtility_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsMathUtility)
public:
	DSRESULT IsSame(dsMathUtility_c* dsObj);

	DSRESULT CreateTransform(const dsDoubleArray&  DataDblArray, dsMathTransform_c ** Transform);
	DSRESULT CreateTransformRotation(dsMathPoint_c * CenterPoint, dsMathVector_c * Axis, double  Angle , dsMathTransform_c ** Transform);
	DSRESULT CreateTransformMirroringAboutPoint(dsMathPoint_c * MirrorPoint, dsMathTransform_c ** Transform);
	DSRESULT CreateTransformMirroringAboutLine(dsMathLine_c * MirrorLine, dsMathTransform_c ** Transform);
	DSRESULT CreateTransformMirroringAboutPlane(dsMathPlane_c * MirrorPlane, dsMathTransform_c ** Transform);
	DSRESULT CreateTransformProjection(dsMathPlane_c * ProjectionPlane, dsMathVector_c * ProjectionDirection, dsMathTransform_c ** Transform);
	DSRESULT CreateTransformScaling(dsMathPoint_c * CenterPoint, double  Scale , dsMathTransform_c ** Transform);
	DSRESULT CreateTransformTranslation(dsMathVector_c * TranslationVector, dsMathTransform_c ** Transform);
	DSRESULT CreatePoint(double  X, double  Y, double  Z, dsMathPoint_c ** MathPoint);
	DSRESULT CreateLine(double  StartX , double  StartY , double  StartZ , double  EndX , double  EndY , double  EndZ, dsMathLineType_e Type , dsMathLine_c ** Line);
	DSRESULT CreateVector(double  X , double  Y , double  Z , dsMathVector_c ** Vector);
	DSRESULT CreateXYPlane(dsMathPlane_c ** Plane);
	DSRESULT CreateYZPlane(dsMathPlane_c ** Plane);
	DSRESULT CreateZXPlane(dsMathPlane_c ** Plane);
	DSRESULT CreatePlaneByNormal(dsMathPoint_c * Origin, dsMathVector_c * Normal, dsMathPlane_c ** Plane);
	DSRESULT CreatePlaneByUV(dsMathPoint_c * Origin, dsMathVector_c * UAxis, dsMathVector_c * VAxis, dsMathPlane_c ** Plane);
	DSRESULT Distance(dsObject * Object1, dsObject * Object2, dsMathPoint_c** Point1, dsMathPoint_c** Point2, double * Result);
	DSRESULT CreateLineByPointAndDirection (double  StartX, double  StartY, double  StartZ , dsMathVector_c * Direction, dsMathLineType_e  Type, dsMathLine_c ** Line);
	DSRESULT CreateCircle(dsMathPoint_c * Center , dsMathVector_c * Normal, double  Radius , dsMathCircArc_c ** CircArc);
	DSRESULT CreateCircArc(dsMathPoint_c * Center , dsMathVector_c * Normal, dsMathVector_c * RefVector, double  Radius , double  StartAngle, double  EndEngle, dsMathCircArc_c ** CircArc);
	DSRESULT CreateCircArcBy3Points(  dsMathPoint_c* StartPoint, dsMathPoint_c * ThroughPoint, dsMathPoint_c * EndPoint, dsMathCircArc_c ** CircArc);
	DSRESULT CreateEllipse(dsMathPoint_c * Center , dsMathVector_c * MajorAxis , dsMathVector_c * MinorAxis , double  MajorRadius , double  MinorRadius , dsMathEllipArc_c ** EllipArc);
	DSRESULT CreateEllipArc(dsMathPoint_c * Center, dsMathVector_c * MajorAxis, dsMathVector_c * MinorAxis, double  MajorRadius, double  MinorRadius, double  StartAngle, double  EndAngle, dsMathEllipArc_c ** EllipArc);
	DSRESULT CreateCircleBy3Points(dsMathPoint_c * FirstPoint, dsMathPoint_c * SecondPoint, dsMathPoint_c * ThirdPoint, dsMathCircArc_c ** CircArc);
};
