//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsModelNamedView_c.h, C++ API dsModelNamedView_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsModelNamedView_p;
class dsModelNamedView;
class dsNamedView_c;
class dsDictionary_c;
class dsSolidBackground_c;
class dsGradientBackground_c;
class dsImageBackground_c;
class DSINTERFACE_EXPORT dsModelNamedView_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsModelNamedView)
public:
	DSRESULT IsSame(dsModelNamedView_c* dsObj);

	DSRESULT GetNamedView(dsNamedView_c ** NamedView);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT GetBackgroundType(dsViewBackgroundType_e*  BackgroundType);
	DSRESULT GetSolidBackground(dsSolidBackground_c ** SolidBackground);
	DSRESULT SetSolidBackground(dsSolidBackground_c * SolidBackground);
	DSRESULT GetGradientBackground(dsGradientBackground_c ** GradientBackground);
	DSRESULT SetGradientBackground(dsGradientBackground_c * GradientBackground);
	DSRESULT GetImageBackground(dsImageBackground_c ** ImageBackground);
	DSRESULT SetImageBackground(dsImageBackground_c * ImageBackground);
	DSRESULT RemoveBackground( );
};
