//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsObject.h, C++ API dsObject interface
//

#pragma once

#include "dsLibrary_global.h"
#include "dsObjectPtrArray.h"
#include "dsConstants.h"
#include "dsResult.h"


class dsObject_pimpl;
class DSLIBRARY_EXPORT dsObject
{
public:
	dsObject();
	virtual ~dsObject();

	void setDsParent(dsObject *connectObj);
	void setDsChild(dsObject *connectObj);
	dsObject *getDsParent();
	dsObjectPtrArray& getDsChildren();
	dsObjectType_e getDsType();

protected:
	void setDsType(dsObjectType_e type);

private:
	dsObject_pimpl *m_dsObject_pimpl;
};	