//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsOrdinateDimension_c.h, C++ API dsOrdinateDimension_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsOrdinateDimension_p;
class dsOrdinateDimension;
class dsGeneralDimension_c;
class DSINTERFACE_EXPORT dsOrdinateDimension_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsOrdinateDimension)
public:
	DSRESULT IsSame(dsOrdinateDimension_c* dsObj);

	DSRESULT GetGeneralDimension(dsGeneralDimension_c ** GeneralDimension);
	DSRESULT GetFeaturePoint(double * X, double * Y, double * Z);
	DSRESULT SetFeaturePoint(double  X, double  Y, double  Z);
	DSRESULT GetLeaderPoint(double * X, double * Y, double * Z);
	DSRESULT SetLeaderPoint(double  X, double  Y, double  Z);
	DSRESULT GetOriginPoint(double * X, double * Y, double * Z);
	DSRESULT SetOriginPoint(double  X, double  Y, double  Z);
	DSRESULT get_Measure(dsOrdinateDimensionMeasure_e* Val);
	DSRESULT put_Measure(dsOrdinateDimensionMeasure_e NewVal);
};
