//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsPolyLine3D_c.h, C++ API dsPolyLine3D_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"
#include "dsDoubleArray.h"

class dsTransparency_c;
class dsPolyLine3D_p;
class dsPolyLine3D;
class dsColor_c;
class dsCustomData_c;
class dsHyperLink_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsPolyLine3D_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsPolyLine3D)
public:
	DSRESULT IsSame(dsPolyLine3D_c* dsObj);

	DSRESULT get_Layer(dsString* Val);
	DSRESULT put_Layer(const dsString& NewVal);
	DSRESULT get_LineStyle(dsString* Val);
	DSRESULT put_LineStyle(const dsString& NewVal);
	DSRESULT get_LineScale(double* Val);
	DSRESULT put_LineScale(double NewVal);
	DSRESULT get_LineWeight(dsLineWeight_e* Val);
	DSRESULT put_LineWeight(dsLineWeight_e NewVal);	
	DSRESULT get_Visible(bool* Val);
	DSRESULT put_Visible(bool NewVal);
	DSRESULT Select(bool SelectFlag, bool* Res);
	DSRESULT get_Color(dsColor_c ** Val);
	DSRESULT put_Color(dsColor_c * NewVal);
	DSRESULT get_Erased(bool * Val);
	DSRESULT put_Erased(bool  NewVal);

	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT get_Handle(dsString*  Val);
	DSRESULT get_Closed(bool * Val);
	DSRESULT put_Closed(bool  NewVal);
	DSRESULT get_FitSmooth(dsPolyLine3DFitSmooth_e* Val);
	DSRESULT put_FitSmooth(dsPolyLine3DFitSmooth_e NewVal);
	DSRESULT GetVerticesCount(long * Val);
	DSRESULT GetVertexCoordinate(long  VertexIndex, double * X, double * Y, double * Z, bool * Success);
	DSRESULT SetVertexCoordinate(long  VertexIndex, double  X, double  Y, double  Z, bool * Success);
	DSRESULT AddVertexAfter(long  VertexIndex, double  X, double  Y, double  Z, bool * Success);
	DSRESULT Split(long  VertexIndex, dsPolyLine3D_c ** NewPolyline, bool * Result);
	DSRESULT Decurve(bool * Success);
	DSRESULT Spline(bool * Success);
	DSRESULT GetHyperLink(dsHyperLink_c ** HyperLink);
	DSRESULT SetHyperLink(dsHyperLink_c * HyperLink);
	DSRESULT DeleteHyperLink( );
	DSRESULT GetLength(double * Length);
	DSRESULT GetClosestPointOn(double  GivenPointX, double  GivenPointY, double  GivenPointZ, double * PointOnCurveX, double * PointOnCurveY, double * PointOnCurveZ);
	DSRESULT GetEndParams(double * StartParameter, double * EndParameter);
	DSRESULT EvaluateAtParameter(double  Parameter, double * PointOnCurveX, double * PointOnCurveY, double * PointOnCurveZ, double * Distance, dsDoubleArray * FirstDerivativeDblArray, dsDoubleArray * SecondDerivativeDblArray);
	DSRESULT EvaluateAtPoint(double  PointOnCurveX, double  PointOnCurveY, double  PointOnCurveZ, double * Parameter, double * Distance, dsDoubleArray * FirstDerivativeDblArray, dsDoubleArray * SecondDerivativeDblArray);
	DSRESULT EvaluateAtDistance(double  Distance, double * PointOnCurveX, double * PointOnCurveY, double * PointOnCurveZ, double * Parameter, dsDoubleArray * FirstDerivativeDblArray, dsDoubleArray * SecondDerivativeDblArray);
	DSRESULT GetBoundingBox(double * X1, double * Y1, double * Z1, double * X2, double * Y2, double * Z2);
	DSRESULT RemoveVertex(long  VertexIndex);
	DSRESULT Straighten(long  VertexIndexStart, long  VertexIndexEnd);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT get_PrintStyle(dsString*  Val);
	DSRESULT put_PrintStyle(const dsString&  NewVal);
	DSRESULT get_Transparency(dsTransparency_c ** Val);
	DSRESULT put_Transparency(dsTransparency_c * NewVal);
};
