//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsRibbonPanel_c.h, C++ API dsRibbonPanel_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsRibbonPanel_p;
class dsRibbonPanel;
class dsRibbonRow_c;
class DSINTERFACE_EXPORT dsRibbonPanel_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsRibbonPanel)
public:
	DSRESULT IsSame(dsRibbonPanel_c* dsObj);

	DSRESULT InsertRibbonRow(const dsString&  ApiUuid, const dsString&  RowName, dsRibbonRow_c ** RibbonRow);
	DSRESULT GetRibbonRow(dsRibbonRow_c ** RibbonRow);
	DSRESULT DisplayInTab(const dsString&  TabName, long  Position);
	DSRESULT RemoveFromTab(const dsString&  TabName);
	DSRESULT Remove( );
	DSRESULT GetType(dsRibbonItemType_e*  ItemType);
	DSRESULT GetApiID(dsString*  ApiUuid);
	DSRESULT get_Name(dsString*  Val);
	DSRESULT put_Name(const dsString&  NewVal);
	DSRESULT get_DisplayText(dsString*  Val);
	DSRESULT put_DisplayText(const dsString&  NewVal);
};
