//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsRibbonQuickAccessBar_c.h, C++ API dsRibbonQuickAccessBar_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsRibbonQuickAccessBar_p;
class dsRibbonQuickAccessBar;
class dsRibbonQuickAccessBarItem_c;
class DSINTERFACE_EXPORT dsRibbonQuickAccessBar_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsRibbonQuickAccessBar)
public:
	DSRESULT IsSame(dsRibbonQuickAccessBar_c* dsObj);

	DSRESULT GetRibbonQuickAccessBarItems(dsObjectPtrArray * RibbonQuickAccessBarItemArray);
	DSRESULT InsertRibbonQuickAccessBarItem(const dsString&  ApiUuid, const dsString&  ItemName, const dsString&  UserCmdID, dsRibbonQuickAccessBarItem_c ** RibbonQuickAccessBarItem);
	DSRESULT Remove( );
	DSRESULT GetType(dsRibbonItemType_e*  ItemType);
	DSRESULT GetApiID(dsString*  ApiUuid);
	DSRESULT get_Name(dsString*  Val);
	DSRESULT put_Name(const dsString&  NewVal);
};
