//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsRibbonRowPanel_c.h, C++ API dsRibbonRowPanel_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsRibbonRowPanel_p;
class dsRibbonRowPanel;
class dsRibbonRow_c;

class DSINTERFACE_EXPORT dsRibbonRowPanel_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsRibbonRowPanel)
public:
	DSRESULT IsSame(dsRibbonRowPanel_c* dsObj);

	DSRESULT InsertRibbonRow(const dsString&  ApiUuid, const dsString&  RowName, dsRibbonRow_c ** RibbonRow);
	DSRESULT GetRibbonRows(dsObjectPtrArray * RibbonRowArray);
	DSRESULT Remove( );
	DSRESULT GetType(dsRibbonItemType_e*  ItemType);
	DSRESULT GetApiID(dsString*  ApiUuid);
	DSRESULT get_Name(dsString*  Val);
	DSRESULT put_Name(const dsString&  NewVal);
};
