//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsRibbonRow_c.h, C++ API dsRibbonRow_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsRibbonRow_p;
class dsRibbonRow;
class dsRibbonRowPanel_c;
class dsRibbonCommandButton_c;
class dsRibbonSeparator_c;
class dsRibbonRowItem_c;
class dsRibbonSplitButton_c;

class DSINTERFACE_EXPORT dsRibbonRow_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsRibbonRow)
public:
	DSRESULT IsSame(dsRibbonRow_c* dsObj);

	DSRESULT InsertRibbonRowPanel(const dsString&  ApiUuid, const dsString&  PanelName, dsRibbonRowPanel_c ** RibbonRowPanel);
	DSRESULT InsertRibbonCommandButton(const dsString&  ApiUuid, dsRibbonButtonStyle_e  ButtonStyle, const dsString&  ItemName, const dsString&  UserCmdID, dsRibbonCommandButton_c ** RibbonCommandButton);
	DSRESULT InsertRibbonSeparator(const dsString&  ApiUuid, dsRibbonSeparatorStyle_e  SeparatorStyle, dsRibbonSeparator_c ** RibbonRowItem);
	DSRESULT InsertRibbonSplitButton(const dsString&  ApiUuid, dsRibbonItemType_e  ItemType, dsRibbonButtonStyle_e  ButtonStyle, dsRibbonSplitButtonListStyle_e  SplitButtonListStyle, dsRibbonSplitButtonBehaviour_e  SplitButtonBehavior, const dsString&  ItemName, dsRibbonSplitButton_c ** RibbonRowItem);
	DSRESULT GetRibbonRowItems(dsObjectPtrArray * RibbonRowItemArray);
	DSRESULT GetRibbonRowPanel(dsRibbonRowPanel_c ** RibbonRowPanelArray);
	DSRESULT Remove( );
	DSRESULT GetType(dsRibbonItemType_e*  ItemType);
	DSRESULT GetApiID(dsString*  ApiUuid);
	DSRESULT get_Name(dsString*  Val);
	DSRESULT put_Name(const dsString&  NewVal);
};
