//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsRibbonSplitButton_c.h, C++ API dsRibbonSplitButton_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsRibbonCommandButton_c.h"

class dsRibbonSplitButton_p;
class dsRibbonSplitButton;
class DSINTERFACE_EXPORT dsRibbonSplitButton_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsRibbonSplitButton)
public:
	DSRESULT IsSame(dsRibbonSplitButton_c* dsObj);

	DSRESULT GetButtonStyle(dsRibbonButtonStyle_e*  ButtonStyle);
	DSRESULT GetSplitButtonListStyle(dsRibbonSplitButtonListStyle_e* SplitButtonListStyle);
	DSRESULT GetSplitButtonBehavior(dsRibbonSplitButtonBehaviour_e*  SplitBehaviour);
	DSRESULT InsertRibbonCommandButton(const dsString&  ApiUuid, dsRibbonButtonStyle_e  ButtonStyle, const dsString&  ItemName, const dsString&  UserCmdID, dsRibbonCommandButton_c ** RibbonCommandButton);
	DSRESULT GetRibbonCommandButtons(dsObjectPtrArray * RibbonCommandButtonArray);
};
