//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsRibbonSystemMenuItem_c.h, C++ API dsRibbonSystemMenuItem_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsRibbonSystemMenuItem_p;
class dsRibbonSystemMenuItem;
class DSINTERFACE_EXPORT dsRibbonSystemMenuItem_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsRibbonSystemMenuItem)
public:
	DSRESULT IsSame(dsRibbonSystemMenuItem_c* dsObj);

	DSRESULT GetRibbonSystemMenuItems(dsObjectPtrArray * RibbonSystemMenuItemArray);
	DSRESULT InsertRibbonSystemMenuItem(const dsString&  ApiUuid, dsRibbonItemType_e  ItemType, const dsString&  ItemName, const dsString&  UserCmdID, dsRibbonSystemMenuItem_c ** RibbonSystemMenuItem);
	DSRESULT Remove( );
	DSRESULT GetType(dsRibbonItemType_e*  ItemType);
	DSRESULT GetApiID(dsString*  ApiUuid);
	DSRESULT GetID(dsString*  ID);
	DSRESULT get_Name(dsString*  Val );
	DSRESULT put_Name(const dsString&  NewVal );
};
