//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsRichLineStyle_c.h, C++ API dsRichLineStyle_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsRichLineStyle_p;
class dsRichLineStyle;
class dsCustomData_c;
class dsColor_c;
class DSINTERFACE_EXPORT dsRichLineStyle_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsRichLineStyle)
public:
	DSRESULT IsSame(dsRichLineStyle_c* dsObj);

	DSRESULT get_Name(dsString*  Val);
	DSRESULT Rename(const dsString&  Name, dsCreateObjectResult_e* Result);
	DSRESULT Activate( );
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT get_Handle(dsString*  Val);
	DSRESULT GetLinesCount(long * Val);
	DSRESULT GetLineOffset(long  VertexIndex, double * Offset);
	DSRESULT SetLineOffset(long  VertexIndex, double  Offset);
	DSRESULT GetLineColor(long  VertexIndex, dsColor_c ** LineColor);
	DSRESULT SetLineColor(long  VertexIndex, dsColor_c * LineColor);
	DSRESULT GetLineStyle(long  VertexIndex, dsString* StyleName);
	DSRESULT SetLineStyle(long  VertexIndex, const dsString&  StyleName);
	DSRESULT AddLine(double  Offset, dsColor_c * LineColor, const dsString&  StyleName);
	DSRESULT DeleteLine(long  VertexIndex);
	DSRESULT get_ShowJunctions(bool * Val);
	DSRESULT put_ShowJunctions(bool  NewVal);
	DSRESULT get_Color(dsColor_c ** Val);
	DSRESULT put_Color(dsColor_c * NewVal);
	DSRESULT get_AngleStart(double * Val);
	DSRESULT put_AngleStart(double  NewVal);
	DSRESULT get_AngleEnd(double * Val);
	DSRESULT put_AngleEnd(double  NewVal);
	DSRESULT get_ExternalArcStart(bool * Val);
	DSRESULT put_ExternalArcStart(bool  NewVal);
	DSRESULT get_ExternalArcEnd(bool * Val);
	DSRESULT put_ExternalArcEnd(bool  NewVal);
	DSRESULT get_InternalArcStart(bool * Val);
	DSRESULT put_InternalArcStart(bool  NewVal);
	DSRESULT get_InternalArcEnd(bool * Val);
	DSRESULT put_InternalArcEnd(bool  NewVal);
	DSRESULT get_LineStart(bool * Val);
	DSRESULT put_LineStart(bool  NewVal);
	DSRESULT get_LineEnd(bool * Val);
	DSRESULT put_LineEnd(bool  NewVal);
};
