//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsRotatedDimension_c.h, C++ API dsRotatedDimension_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsRotatedDimension_p;
class dsRotatedDimension;
class dsGeneralDimension_c;
class DSINTERFACE_EXPORT dsRotatedDimension_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsRotatedDimension)
public:
	DSRESULT IsSame(dsRotatedDimension_c* dsObj);

	DSRESULT GetGeneralDimension(dsGeneralDimension_c ** GeneralDimension);
	DSRESULT GetExtensionLine1Point(double * X, double * Y, double * Z);
	DSRESULT SetExtensionLine1Point(double  X, double  Y, double  Z);
	DSRESULT GetExtensionLine2Point(double * X, double * Y, double * Z);
	DSRESULT SetExtensionLine2Point(double  X, double  Y, double  Z);
	DSRESULT GetDimensionLinePoint(double * X, double * Y, double * Z);
	DSRESULT SetDimensionLinePoint(double  X, double  Y, double  Z);
	DSRESULT get_Rotation(double * Val);
	DSRESULT put_Rotation(double  NewVal);
	DSRESULT get_ObliquingAngle(double * Val);
	DSRESULT put_ObliquingAngle(double  Val);
};
