
//							SOURCE CODE LICENSE							  //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsSketchManager_c.h, C++ API dsSketchManager_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsObject.h"
#include "dsConstants.h"
#include "dsDoubleArray.h"
#include "dsStringArray.h"
#include "dsLongArray.h"
#include "dsSelectionFilter_c.h"

class dsSketchManager;
class dsExternalReference_c;
class dsLine_c;
class dsBlockInstance_c;
class dsString;
class dsReferenceImage_c;
class dsBlockDefinition_c;
class dsCircle_c;
class dsPoint_c;
class dsCircleArc_c;
class dsSimpleNote_c;
class dsRay_c;
class dsInfiniteLine_c;
class dsEllipseArc_c;
class dsPolyLine_c;
class dsSketchManager_p;
class dsNote_c;
class dsRichLine_c;
class dsAngularDimension_c;
class dsAlignedDimension_c;
class dsRotatedDimension_c;
class dsArcLengthDimension_c;
class dsDiameterDimension_c;
class dsRadialDimension_c;
class dsJoggedDimension_c;
class dsOrdinateDimension_c;
class dsLeader_c;
class dsTolerance_c;
class dsPolyLine3D_c;
class dsSpline_c;
class dsHyperLink_c;
class dsFace_c;
class dsSolid_c;
class dsPolygonMesh_c;
class dsPolyFaceMesh_c;
class dsHatch_c;
class dsAttributeDefinition_c;
class dsEmbeddedObject_c;
class dsRegion_c;
class dsTable_c;
class dsMathPoint_c;
class dsViewport_c;
class dsShape_c;
class dsTrace_c;
class dsArcAlignedText_c;

class DSINTERFACE_EXPORT dsSketchManager_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsSketchManager)
public:
	DSRESULT IsSame(dsSketchManager_c* Obj);

	DSRESULT InsertExternalReference(const dsString& PathName, double InsertX, double InsertY, double InsertZ, double Scale, double Rotation, dsBlockInstance_c** BInst);
	DSRESULT InsertLine(double StartX, double StartY, double StartZ, double EndX, double EndY, double EndZ, dsLine_c** Line);
	DSRESULT InsertBlock(const dsString& BlockName, double InsertX, double InsertY, double InsertZ, double Scale, double Rotation, dsBlockInstance_c** Blk);
	DSRESULT InsertPicture(const dsString& PathName, double InsertX, double InsertY, double InsertZ, double Scale, double Rotation, dsReferenceImage_c** Pic);
	DSRESULT GetBoundingBox(double* X1, double* Y1, double* Z1, double* X2, double* Y2, double* Z2);
	DSRESULT InsertCircle(double CenterX, double CenterY, double CenterZ, double Radius, dsCircle_c** Circle);
	DSRESULT InsertPoint(double PointX, double PointY, double PointZ, dsPoint_c** Point) ;
	DSRESULT InsertArc(double CenterX, double CenterY, double CenterZ, double Radius, double StartAngle, double EndAngle, dsCircleArc_c** CircleArc);
	DSRESULT InsertSimpleNote(double StartX, double StartY, double StartZ, double Height, double Angle, const dsString& Value, dsSimpleNote_c** SimpleNote);
	DSRESULT InsertRay(double StartX, double StartY, double StartZ, double ThroughX, double ThroughY, double ThroughZ, dsRay_c** Ray);
	DSRESULT InsertInfiniteLine(double X1, double Y1, double Z1, double X2, double Y2, double Z2, dsInfiniteLine_c** InfiniteLine);
	DSRESULT InsertEllipseDistanceToOtherAxis(double  X1, double  Y1, double  X2, double  Y2, double  DistanceToOtherAxis, dsEllipseArc_c ** EllipseArc);
	DSRESULT InsertEllipseRotation(double  X1, double  Y1, double  X2, double  Y2, double  Rotation, dsEllipseArc_c ** EllipseArc);
	DSRESULT InsertEllipseArcDistanceToOtherAxis(double  X1, double  Y1, double  X2, double  Y2, double  DistanceToOtherAxis, double  StartAngle, double  EndAngle, dsEllipseArc_c ** EllipseArc);
	DSRESULT InsertEllipseArcRotation(double  X1, double  Y1, double  X2, double  Y2, double  Rotation, double  StartAngle, double  EndAngle, dsEllipseArc_c ** EllipseArc);
	DSRESULT InsertPolyline2D(const dsDoubleArray& CoordinateDblArray, bool  Closed, dsPolyLine_c** PolyLine);
	DSRESULT InsertNote(double  X1, double  Y1, double  Z1, double  X2, double  Y2, double  Z2, const dsStringArray&  StrArray, dsNote_c ** Note);
	DSRESULT InsertNoteWithParameters(double  X1, double  Y1, double  Z1, double  X2, double  Y2, double  Z2, const dsStringArray& StrArray, double  Angle, double  Height, dsNoteJustification_e Justify, dsNoteLineSpacingStyle_e LineSpacingStyle, double  LineSpaceDistance, const dsString&  TextStyle, double  Width, dsNote_c ** Note);
	DSRESULT InsertRichLine(const dsDoubleArray& CoordinateDblArray, dsRichLineJustification_e Justification, double Scale, const dsString&  StyleName, bool  Closed, dsRichLine_c ** RichLine);
	DSRESULT InsertAngularDimension3Point(const dsDoubleArray& CenterPointDblArray, const dsDoubleArray&  AngleStartPointDblArray, const dsDoubleArray&  AngleEndPointDblArray, const dsDoubleArray&  DimensionPositionDblArray, const dsString&  DimensionTextOverride, dsAngularDimension_c ** AngularDimension);
	DSRESULT InsertAngularDimensionArc(dsCircleArc_c * Arc, const dsDoubleArray& DimensionPositionDblArray, const dsString&  DimensionTextOverride, dsAngularDimension_c ** AngularDimension);
	DSRESULT InsertAngularDimension2Line(dsLine_c * Line1, dsLine_c * Line2, const dsDoubleArray& DimensionPositionDblArray, const dsString&  DimensionTextOverride, dsAngularDimension_c ** AngularDimension);
	DSRESULT InsertAlignedDimension(const dsDoubleArray& ExtensionLine1PointDblArray, const dsDoubleArray& ExtensionLine2PointDblArray, const dsDoubleArray& DimensionLinePointDblArray, const dsString&  DimensionTextOverride, dsAlignedDimension_c ** AlignedDimension);
	DSRESULT InsertRotatedDimension(const dsDoubleArray& ExtensionLine1PointDblArray, const dsDoubleArray& ExtensionLine2PointDblArray, const dsDoubleArray& DimensionLinePointDblArray, const dsString&  DimensionTextOverride, double RotationAngle, dsRotatedDimension_c ** RotatedDimension);
	DSRESULT InsertArcLengthDimension(dsCircleArc_c * Arc, const dsDoubleArray& DimensionPositionDblArray, const dsString&  DimensionTextOverride, dsArcLengthDimension_c ** ArcLengthDimension);
	DSRESULT InsertArcLengthDimensionPartial(dsCircleArc_c * Arc, const dsDoubleArray& FirstPointDblArray, const dsDoubleArray& SecondPointDblArray, const dsDoubleArray& DimensionPositionDblArray, const dsString&  DimensionTextOverride, dsArcLengthDimension_c** ArcLengthDimension);
	DSRESULT InsertDiameterDimensionArc(dsCircleArc_c * Arc, const dsDoubleArray& DimensionPositionDblArray, const dsString&  DimensionTextOverride, dsDiameterDimension_c ** DiameterDimension);
	DSRESULT InsertDiameterDimensionCircle(dsCircle_c * Circle, const dsDoubleArray& DimensionPositionDblArray, const dsString&  DimensionTextOverride, dsDiameterDimension_c ** DiameterDimension);
	DSRESULT InsertRadialDimensionArc(dsCircleArc_c * Arc, const dsDoubleArray& DimensionPositionDblArray, const dsString&  DimensionTextOverride, dsRadialDimension_c ** RadialDimension);
	DSRESULT InsertRadialDimensionCircle(dsCircle_c * Circle, const dsDoubleArray& DimensionPositionDblArray, const dsString&  DimensionTextOverride, dsRadialDimension_c ** RadialDimension);
	DSRESULT InsertJoggedDimensionArc(dsCircleArc_c * CircleArc, const dsDoubleArray& CenterPositionOverrideDblArray, const dsDoubleArray& JogLinePositionDblArray, const dsDoubleArray& DimensionTextPositionDblArray, const dsString&  DimensionTextOverride, dsJoggedDimension_c ** JoggedDimension);
	DSRESULT InsertJoggedDimensionCircle(dsCircle_c * Circle, const dsDoubleArray& CenterPositionOverrideDblArray, const dsDoubleArray& JogLinePositionDblArray, const dsDoubleArray& DimensionTextPositionDblArray, const dsString&  DimensionTextOverride, dsJoggedDimension_c ** JoggedDimension);
	DSRESULT InsertOrdinateDimension(const dsDoubleArray& DatumPositionDblArray, const dsDoubleArray& DimensionPositionDblArray, const dsString&  DimensionTextOverride, dsOrdinateDimensionMeasure_e Measure, dsOrdinateDimension_c ** OrdinateDimension);
	DSRESULT InsertTolerance(const dsDoubleArray& TolerancePositionDblArray, const dsString&  TextString, dsTolerance_c ** Tolerance);
	DSRESULT InsertLeader(const dsDoubleArray&  VertexCoordinateDblArray, double  NoteWidth, const dsString&  NoteText, dsLeader_c ** Leader);
	DSRESULT InsertPolyline3D(const dsDoubleArray&  CoordinateDblArray, bool  Closed, dsPolyLine3D_c ** PolyLine3D);
	DSRESULT InsertSpline(const dsDoubleArray&  CoordinateDblArray, bool  Closed, double  StartTangencyX, double  StartTangencyY, double  StartTangencyZ, double  EndTangencyX, double  EndTangencyY, double  EndTangencyZ, dsSpline_c ** Spline);
	DSRESULT AttachLinkToArea(double  StartCornerX, double  StartCornerY, double  StartCornerZ, double  OppositeCornerX, double  OppositeCornerY, double  OppositeCornerZ, const dsString&  HyperLinkAddress, const dsString&  Description, dsPolyLine3D_c ** PolyLine3D, dsHyperLink_c ** HyperLink);
	DSRESULT InsertFace(const dsDoubleArray&  CoordinateDblArray, bool  Edge1Visible, bool  Edge2Visible, bool  Edge3Visible, bool  Edge4Visible, dsFace_c ** Face);
	DSRESULT InsertSolid(const dsDoubleArray&  CoordinateDblArray, dsSolid_c ** Solid);
	DSRESULT InsertPolygonMesh(long  MVertexCount, long  NVertexCount, const dsDoubleArray&  CoordinateDblArray, dsPolygonMesh_c** PolygonMesh);
	DSRESULT InsertPolyFaceMesh(long  VerticesCount, const dsDoubleArray&  CoordinateDblArray, const dsLongArray&  FaceVerticesCountLongArray, const dsLongArray&  FaceVerticesLongArray, dsPolyFaceMesh_c ** PolyFaceMesh);
	DSRESULT GetEntities(dsSelectionFilter_c * Filter, const dsStringArray&  LayerNamesStrArray, dsLongArray* EntityTypeLongArray, dsObjectPtrArray * EntitiesArray);
	DSRESULT PatternCircular(dsBasePatternOn_e BasePatternOn, double  AngleBetween, double  FillAngle, long  TotalNumber, double  ElementBasePointX, double  ElementBasePointY, double  AxisPointX, double  AxisPointY, bool  OrientElementsAboutAxis, const dsLongArray& EntityTypeLongArray, const dsObjectPtrArray&  EntitiesArray);
	DSRESULT PatternLinear(long  NumberElementsOnVerticalAxis, long  NumberElementsOnHorizontalAxis, double  SpacingOnVerticalAxis, double  SpacingOnHorizontalAxis, double  PatternAngle, const dsLongArray& EntityTypeLongArray, const dsObjectPtrArray&  EntitiesArray);
	DSRESULT CopyEntities(double  DisplacementX, double  DisplacementY, double  DisplacementZ, const dsLongArray& EntityTypeLongArray, const dsObjectPtrArray&  EntitiesArray);
	DSRESULT RotateEntities(double  PivotPointX, double  PivotPointY, double  RotateAngle, const dsLongArray& EntityTypeLongArray, const dsObjectPtrArray&  EntitiesArray);
	DSRESULT MirrorEntities(double  StartPointOfMirrorLineX, double  StartPointOfMirrorLineY, double  StartPointOfMirrorLineZ, double  EndPointOfMirrorLineX, double  EndPointOfMirrorLineY, double  EndPointOfMirrorLineZ, bool  DeleteSourceEntities, const dsLongArray& EntityTypeLongArray, const dsObjectPtrArray&  EntitiesArray);
	DSRESULT ScaleEntities(double  BasePointX, double  BasePointY, double  BasePointZ, double  ScaleFactor, const dsLongArray& EntityTypeLongArray, const dsObjectPtrArray&  EntitiesArray);
	DSRESULT InsertHatchByBoundary(const dsLongArray&  BoundaryPointCountLongArray, const dsDoubleArray&  BoundaryPointDblArray, const dsString&  PatternName, double  PatternScale, double  PatternAngle, dsHatch_c ** Hatch);
	DSRESULT InsertAttributeDefinition(const dsString&  Name , const dsString&  Caption , const dsString&  DefaultValue , double  PositionX , double  PositionY, double  PositionZ, const dsString&  TextStyle, dsTextJustification_e Justification, double  Height , double  Rotation, bool  Fixed, bool  Hidden, bool  Predefined, bool  Validate, bool  LockInBlock, bool  PositionBelowLastDefinition, dsAttributeDefinition_c  ** AttributeDefinition);
	DSRESULT InsertHatchByEntities(const dsObjectPtrArray&  EntitiesArray, const dsString&  PatternName, double  PatternScale, double  PatternAngle, dsHatch_c  ** Hatch);
	DSRESULT InsertHatchByInternalPoints(const dsDoubleArray& InternalPointsDblArray, const dsString&  PatternName, double  PatternScale , double  PatternAngle, dsHatch_c  ** Hatch);
	DSRESULT MoveEntities(double  DisplacementX, double  DisplacementY, double  DisplacementZ, const dsObjectPtrArray&  EntitiesArray);
	DSRESULT FilletEntities(const dsDoubleArray&  FirstPointOnEntityDblArray, const dsObjectPtrArray&  FirstEntityArray, const dsDoubleArray&  SecondPointOnEntityDblArray, const dsObjectPtrArray&  SecondEntityArray);
	DSRESULT ChamferEntities(const dsDoubleArray&  FirstPointOnEntityDblArray, const dsObjectPtrArray&  FirstEntityArray, const dsDoubleArray&  SecondPointOnEntityDblArray, const dsObjectPtrArray&  SecondEntityArray);
	DSRESULT TrimEntities(const dsObjectPtrArray&  CuttingEntitiesArray,const dsObjectPtrArray&  EntitiesToRemoveArray, const dsDoubleArray&  PointOnEntityDblArray);
	DSRESULT ExtendEntities(const dsObjectPtrArray&  BoundaryEntitiesArray, const dsObjectPtrArray&  EntitiesToExtendArray, const dsDoubleArray&  PointOnEntityDblArray);
	DSRESULT StretchEntities(double  DisplacementX, double  DisplacementY, double  DisplacementZ, const dsObjectPtrArray&  EntitiesArray, const dsDoubleArray&  CrossingBoxStartCornerDblArray, const dsDoubleArray&  CrossingBoxOppositeCornerDblArray);
	DSRESULT InsertEmbeddedObjectFromFile(const dsString&  FilePath, bool  Link, bool  DisplayAsIcon, dsEmbeddedObject_c ** EmbeddedObject);
	DSRESULT IsObjectErased(dsObject * Obj, bool * Value);
	DSRESULT SetObjectErased(dsObject * Obj, bool  Value);
	DSRESULT GetObjectLayer(dsObject * Obj, dsString*  Layer);
	DSRESULT SetObjectLayer(dsObject * Obj, const dsString&  Layer);
	DSRESULT IsObjectVisible(dsObject * Obj, bool * Visible);
	DSRESULT SetObjectVisible(dsObject * Obj, bool  Visible);

	DSRESULT InsertRegion(const dsObjectPtrArray&  EntitiesArray, dsObjectPtrArray * RegionArray);
	DSRESULT InsertTable(double  Left, double  Top, long  Rows, long  Columns, double  RowHeight, double  ColumnWidth, dsTableCellType_e FirstRowStyle, dsTableCellType_e SecondRowStyle, dsTableCellType_e OtherRowStyle, dsTable_c ** Table);
	DSRESULT InsertBlock2(const dsString& BlockName, double InsertX, double InsertY, double InsertZ, double ScaleX,double ScaleY,double ScaleZ, double Rotation, dsBlockInstance_c** Blk);
	DSRESULT InsertCircleBy3Points(dsMathPoint_c * FirstPoint, dsMathPoint_c * SecondPoint, dsMathPoint_c * ThirdPoint, dsCircle_c ** Circle);
	DSRESULT InsertCircleByDiameter(double  CenterX, double  CenterY, double  CenterZ, double  Diameter, dsCircle_c ** Circle);
	DSRESULT InsertArcBy3Points(dsMathPoint_c * FirstPoint, dsMathPoint_c * SecondPoint, dsMathPoint_c * ThirdPoint, dsCircleArc_c ** CircleArc);
	DSRESULT InsertArcByCenter2Points2(dsMathPoint_c * CenterPoint, dsMathPoint_c * FirstPoint, dsMathPoint_c * SecondPoint, dsCircleArc_c ** CircleArc);
	DSRESULT InsertLinearDimension(const dsDoubleArray& ExtensionLine1PointDblArray, const dsDoubleArray& ExtensionLine2PointDblArray, const dsDoubleArray&  DimensionLinePointDblArray, const dsString&  DimensionTextOverride, dsRotatedDimension_c ** LinearDimension);
	DSRESULT InsertArcByCenter2Points(const dsDoubleArray&  CenterPointsDblArray, const dsDoubleArray&  FirstPointsDblArray, const dsDoubleArray&  SecondPointsDblArray, dsCircleArc_c ** CircleArc);
	DSRESULT AddTemporaryEntity(dsObject * Entity );
	DSRESULT DetachExternalReference(dsExternalReference_c * ExternalReference, bool * Retval);
	DSRESULT AlignEntities1Point(dsMathPoint_c * SourcePoint, dsMathPoint_c * DestinationPoint, const dsObjectPtrArray&  EntitiesArray );
	DSRESULT AlignEntities2Point(dsMathPoint_c * FirstSourcePoint, dsMathPoint_c * FirstDestinationPoint, dsMathPoint_c * SecondSourcePoint, dsMathPoint_c * SecondDestinationPoint, bool  ScaleEntities, const dsObjectPtrArray&  EntitiesArray );
	DSRESULT BringToFrontEntities(const dsObjectPtrArray&  EntitiesArray);
	DSRESULT SendToBackEntities(const dsObjectPtrArray&  EntitiesArray);
	DSRESULT BringAboveEntities(const dsObjectPtrArray&  EntitiesArray, const dsObjectPtrArray&  ReferenceEntitiesArray);
    DSRESULT SendToUnderEntities(const dsObjectPtrArray&  EntitiesArray, const dsObjectPtrArray&  ReferenceEntitiesArray);
    DSRESULT AlignEntities3Point(dsMathPoint_c * FirstSourcePoint, dsMathPoint_c * FirstDestinationPoint, dsMathPoint_c * SecondSourcePoint, dsMathPoint_c * SecondDestinationPoint, dsMathPoint_c * ThirdSourcePoint, dsMathPoint_c * ThirdDestinationPoint, const dsObjectPtrArray&  EntitiesArray );
    DSRESULT Rotate3DEntities( dsMathPoint_c * FirstAxisThroughPoint, dsMathPoint_c * SecondAxisThroughPoint, double Angle, const dsObjectPtrArray& EntitiesArray );
    DSRESULT Mirror3DEntities( dsMathPoint_c * FirstPointOnMirrorPlane, dsMathPoint_c * SecondPointOnMirrorPlane, dsMathPoint_c * ThirdPointOnMirrorPlane, bool DeleteSourceEntities, const dsObjectPtrArray& EntitiesArray );
    DSRESULT Align3DEntities( dsMathPoint_c * FirstBasePoint, dsMathPoint_c * SecondBasePoint, dsMathPoint_c * ThirdBasePoint, dsMathPoint_c * FirstDestinationPoint, dsMathPoint_c * SecondDestinationPoint, dsMathPoint_c * ThirdDestinationPoint, const dsObjectPtrArray& EntitiesArray );
	DSRESULT Pattern3DLinear(long  NumberElementsOnVerticalAxis, long  NumberElementsOnHorizontalAxis, long  NumberLevels, double  VerticalSpacing, double  HorizontalSpacing, double  SpacingBetweenLevels, const dsObjectPtrArray& EntitiesArray);
	DSRESULT Pattern3DCircular(long  NumberItemsInPattern, double  AngleToFill, bool  RotatePatternElements, dsMathPoint_c * CenterPoint, dsMathPoint_c * SecondPointOnAxis, const dsObjectPtrArray& EntitiesArray);
	DSRESULT ExplodeEntities(const dsObjectPtrArray& EntitiesArray);
	DSRESULT InsertShape(const dsString&  Name, double  PositionX, double  PositionY, double  PositionZ, double  Height, double  Rotation, dsShape_c ** Shape);
    DSRESULT DetachReferenceImage(dsReferenceImage_c* ReferenceImage, bool* Retval);
    DSRESULT InsertTrace(const dsDoubleArray& CoordinateDblArray, dsTrace_c** Trace);
	DSRESULT FilletPolyLine(dsPolyLine_c * PolyLine);
	DSRESULT ChamferPolyLine(dsPolyLine_c * PolyLine);
    DSRESULT InsertAttributeDefinition2(const dsString&  Name , const dsString&  Caption , const dsString&  DefaultValue , double  PositionX , double  PositionY, double  PositionZ, const dsString&  TextStyle, dsTextJustification_e Justification, double  Height , double  Rotation, bool  Fixed, bool  Hidden, bool  Predefined, bool  Validate, bool  LockInBlock, bool  PositionBelowLastDefinition, bool  Multilines, dsAttributeDefinition_c  ** AttributeDefinition);
	DSRESULT InsertCurvedText(const dsString&  Contents, dsCircleArc_c * CircleArc, dsArcAlignedText_c ** ArcAlignedText);
};
