//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsSolid_c.h, C++ API dsSolid_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsTransparency_c;
class dsSolid_p;
class dsSolid;
class dsColor_c;
class dsCustomData_c;
class dsHyperLink_c;
class dsMathVector_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsSolid_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsSolid)
public:
	DSRESULT IsSame(dsSolid_c* dsObj);

	DSRESULT get_Layer(dsString* Val);
	DSRESULT put_Layer(const dsString& NewVal);
	DSRESULT get_LineStyle(dsString* Val);
	DSRESULT put_LineStyle(const dsString& NewVal);
	DSRESULT get_LineScale(double* Val);
	DSRESULT put_LineScale(double NewVal);
	DSRESULT get_LineWeight(dsLineWeight_e* Val);
	DSRESULT put_LineWeight(dsLineWeight_e NewVal);	
	DSRESULT get_Visible(bool* Val);
	DSRESULT put_Visible(bool NewVal);
	DSRESULT Select(bool SelectFlag, bool* Res);
	DSRESULT get_Color(dsColor_c ** Val);
	DSRESULT put_Color(dsColor_c * NewVal);
	DSRESULT get_Erased(bool * Val);
	DSRESULT put_Erased(bool  NewVal);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT get_Handle(dsString*  Val);

	DSRESULT GetVertex1Coordinate(double * X, double * Y, double * Z);
	DSRESULT GetVertex2Coordinate(double * X, double * Y, double * Z);
	DSRESULT GetVertex3Coordinate(double * X, double * Y, double * Z);
	DSRESULT GetVertex4Coordinate(double * X, double * Y, double * Z);
	DSRESULT SetVertex1Coordinate(double  X, double  Y, double  Z);
	DSRESULT SetVertex2Coordinate(double  X, double  Y, double  Z);
	DSRESULT SetVertex3Coordinate(double  X, double  Y, double  Z);
	DSRESULT SetVertex4Coordinate(double  X, double  Y, double  Z);
	DSRESULT GetHyperLink(dsHyperLink_c ** HyperLink);
	DSRESULT SetHyperLink(dsHyperLink_c * HyperLink);
	DSRESULT DeleteHyperLink( );
	DSRESULT GetBoundingBox(double * X1, double * Y1, double * Z1, double * X2, double * Y2, double * Z2);
	DSRESULT get_Thickness(double * Val);
	DSRESULT put_Thickness(double  Val);
	DSRESULT GetNormal(dsMathVector_c ** Normal);
	DSRESULT SetNormal(dsMathVector_c * Normal);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT get_PrintStyle(dsString*  Val);
	DSRESULT put_PrintStyle(const dsString&  NewVal);
	DSRESULT get_Transparency(dsTransparency_c ** Val);
	DSRESULT put_Transparency(dsTransparency_c * NewVal);
};
