//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsString.h, C++ API dsString interface
//

#pragma once

#ifdef DS_WIN
#include <malloc.h>
#else //DS_WIN
#include <stdlib.h>
#include <wchar.h>
#endif //DS_WIN 

#include "dsLibrary_global.h"

class dsString_pimpl;
class DSLIBRARY_EXPORT dsString
{
public:
	dsString();
    dsString(const wchar_t* strIn);
    dsString(const dsString &a);
    ~dsString();

    dsString& operator = (const dsString &dsStr);
	dsString& operator = (const wchar_t *wChar); 

	operator wchar_t*() const; 
    size_t getSize() const; 
	int CompareNoCase( const dsString &dsStr ) const;
	int Compare( const dsString &dsStr ) const;
    bool operator == (const dsString &dsStr) const; 
    bool operator != (const dsString &dsStr) const; 
    bool operator < (const dsString &dsStr) const; 
    bool operator <= (const dsString &dsStr) const; 
    bool operator > (const dsString &dsStr) const; 
    bool operator >= (const dsString &dsStr) const; 

private:
	dsString_pimpl *getImpl() const;
	dsString_pimpl *m_dsString_pimpl;
};