//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsSystemFiles_c.h, C++ API dsSystemFiles_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"
#include "dsStringArray.h"

class dsSystemFiles_p;
class dsSystemFiles;
class DSINTERFACE_EXPORT dsSystemFiles_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsSystemFiles)
public:
	DSRESULT IsSame(dsSystemFiles_c* dsObj);

	DSRESULT get_CustomDictionaryFile(dsString*  Val);
	DSRESULT put_CustomDictionaryFile(const dsString&  NewVal);
	DSRESULT get_MainDictionaryFile(dsString*  Val);
	DSRESULT put_MainDictionaryFile(const dsString&  NewVal);
	DSRESULT get_HelpFile(dsString*  Val);
	DSRESULT put_HelpFile(const dsString&  NewVal);
	DSRESULT get_LogFilePath(dsString*  Val);
	DSRESULT put_LogFilePath(const dsString&  NewVal);
	DSRESULT get_TempPath(dsString*  Val);
	DSRESULT put_TempPath(const dsString&  NewVal);
	DSRESULT get_FontsPaths(dsStringArray * StrArray);
	DSRESULT put_FontsPaths(const dsStringArray& NewStrArray);
	DSRESULT get_SupportPaths(dsStringArray * StrArray);
	DSRESULT put_SupportPaths(const dsStringArray& NewStrArray);
    DSRESULT GetUserDataPath(dsString* Val);
	DSRESULT get_DrawingBorderPaths(dsStringArray * StrArray);
	DSRESULT put_DrawingBorderPaths(const dsStringArray &  NewStrArray);
	DSRESULT get_TitleBlockPaths(dsStringArray * StrArray);
	DSRESULT put_TitleBlockPaths(const dsStringArray &  NewStrArray);
};
