//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsTableStyleManager_c.h, C++ API dsTableStyleManager_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsTableStyleManager_p;
class dsTableStyleManager;
class dsTableStyle_c;
class DSINTERFACE_EXPORT dsTableStyleManager_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsTableStyleManager)
public:
	DSRESULT IsSame(dsTableStyleManager_c* dsObj);

	DSRESULT CreateTableStyle(const dsString&  Name, dsTableStyle_c ** TableStyle, dsCreateObjectResult_e* Result);
	DSRESULT GetTableStyle(const dsString&  Name, dsTableStyle_c ** TableStyle);
	DSRESULT GetTableStyles(dsObjectPtrArray * TableStyleArray);
	DSRESULT RemoveTableStyle(const dsString&  Name, bool * Result);
	DSRESULT GetActiveTableStyle(dsTableStyle_c ** TableStyle);
};
