//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsTableStyle_c.h, C++ API dsTableStyle_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsTableStyle_p;
class dsTableStyle;
class dsColor_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsTableStyle_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsTableStyle)
public:
	DSRESULT IsSame(dsTableStyle_c* dsObj);

	DSRESULT get_Name(dsString*  Val);
	DSRESULT Rename(const dsString&  Name, dsCreateObjectResult_e* Result);
	DSRESULT Activate( );
	DSRESULT get_HeaderOrientation(dsTableHeaderOrientation_e* Val);
	DSRESULT put_HeaderOrientation(dsTableHeaderOrientation_e NewVal);
	DSRESULT GetBackgroundColor(dsTableCellType_e CellType, dsColor_c ** Val);
	DSRESULT SetBackgroundColor(dsTableCellType_e CellType, dsColor_c * NewVal);
	DSRESULT GetAlignment(dsTableCellType_e CellType, dsTableCellAlignment_e* Val);
	DSRESULT SetAlignment(dsTableCellType_e CellType, dsTableCellAlignment_e NewVal);
	DSRESULT GetTextColor(dsTableCellType_e CellType, dsColor_c ** Val);
	DSRESULT SetTextColor(dsTableCellType_e CellType, dsColor_c * NewVal);
	DSRESULT GetTextStyle(dsTableCellType_e CellType, dsString*  Val);
	DSRESULT SetTextStyle(dsTableCellType_e CellType, const dsString&  NewVal);
	DSRESULT GetTextHeight(dsTableCellType_e CellType, double * Val);
	DSRESULT SetTextHeight(dsTableCellType_e CellType, double  NewVal);
	DSRESULT GetBordersVisibility(dsTableCellType_e CellType, dsTableBordersLineType_e LineType, bool * Val);
	DSRESULT SetBordersVisibility(dsTableCellType_e CellType, dsTableBordersLineType_e LineType, bool  NewVal);
	DSRESULT GetBordersColor(dsTableCellType_e CellType, dsTableBordersLineType_e LineType, dsColor_c ** Val);
	DSRESULT SetBordersColor(dsTableCellType_e CellType, dsTableBordersLineType_e LineType, dsColor_c * NewVal);
	DSRESULT GetBordersLineWeight(dsTableCellType_e CellType, dsTableBordersLineType_e LineType, dsLineWeight_e* Val);
	DSRESULT SetBordersLineWeight(dsTableCellType_e CellType, dsTableBordersLineType_e LineType, dsLineWeight_e NewVal);
	DSRESULT GetHorizontalMargin(dsTableCellType_e CellType, double * Val);
	DSRESULT SetHorizontalMargin(dsTableCellType_e CellType, double  NewVal);
	DSRESULT GetVerticalMargin(dsTableCellType_e CellType, double * Val);
	DSRESULT SetVerticalMargin(dsTableCellType_e CellType, double  NewVal);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
};
