//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsTracker_c.h, C++ API dsTracker_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsTracker_p;
class dsTracker;
class DSINTERFACE_EXPORT dsTracker_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsTracker)
public:
	DSRESULT IsSame(dsTracker_c* dsObj);
    DSRESULT RegisterEvent(dsTrackerEvent_id_e eventId, void* eventClassPtr, void *eventFuncPtr);
    DSRESULT UnRegisterEvent(dsTrackerEvent_id_e eventId, void* eventClassPtr, void *eventFuncPtr);
	DSRESULT AddTemporaryEntity(dsObject * Entity);
	DSRESULT RemoveTemporaryEntity(dsObject * Entity);
};

#define DeclareTrackerUpdateNotifyHook static bool UpdateNotifyHook(void* eventClassPtr, dsMathPoint_c * CursorPosition);

#define ImplementTrackerUpdateNotifyHook(EventClass)                                    \
bool EventClass::UpdateNotifyHook(void* eventClassPtr, dsMathPoint_c * CursorPosition)    \
{                                                                                       \
    return ((EventClass *) eventClassPtr)->UpdateNotify(CursorPosition);                \
}

#define RegisterTrackerUpdateNotifyHook(dsObject) dsObject->RegisterEvent(dsTracker_UpdateNotify_id, this, (void *) UpdateNotifyHook);

#define UnRegisterTrackerUpdateNotifyHook(dsObject) dsObject->UnRegisterEvent(dsTracker_UpdateNotify_id, this, (void *) UpdateNotifyHook);