//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsUnknownEntity_c.h, C++ API dsUnknownEntity_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsUnknownEntity_p;
class dsUnknownEntity;
class dsColor_c;
class dsCustomData_c;
class dsHyperLink_c;
class dsTransparency_c;
class dsMathVector_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsUnknownEntity_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsUnknownEntity)
public:
	DSRESULT IsSame(dsUnknownEntity_c* dsObj);

	DSRESULT get_Layer(dsString* Val);
	DSRESULT put_Layer(dsString NewVal);
	DSRESULT get_LineStyle(dsString* Val);
	DSRESULT put_LineStyle(dsString NewVal);
	DSRESULT get_LineScale(double* Val);
	DSRESULT put_LineScale(double NewVal);
	DSRESULT get_LineWeight(dsLineWeight_e* Val);
	DSRESULT put_LineWeight(dsLineWeight_e NewVal);	
	DSRESULT get_Visible(bool* Val);
	DSRESULT put_Visible(bool NewVal);
	DSRESULT Select(bool SelectFlag, bool* Res);
	DSRESULT get_Color(dsColor_c ** Val);
	DSRESULT put_Color(dsColor_c * NewVal);
	DSRESULT get_Erased(bool * Val);
	DSRESULT put_Erased(bool  NewVal);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT get_Handle(dsString*  Val);
	DSRESULT GetHyperLink(dsHyperLink_c ** HyperLink);
	DSRESULT SetHyperLink(dsHyperLink_c * HyperLink);
	DSRESULT DeleteHyperLink( );
	DSRESULT GetBoundingBox(double * X1, double * Y1, double * Z1, double * X2, double * Y2, double * Z2);
	DSRESULT get_ClassName(dsString*  pVal);
	DSRESULT get_PrintStyle(dsString*  pVal);
	DSRESULT put_PrintStyle(const dsString&  newVal);
	DSRESULT get_Transparency(dsTransparency_c ** pVal);
	DSRESULT put_Transparency(dsTransparency_c * newVal);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
};
