//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsUserCommand_c.h, C++ API dsUserCommand_c interface
//
#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsUserCommand_p;
class dsUserCommand;
class DSINTERFACE_EXPORT dsUserCommand_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsUserCommand)
public:
	DSRESULT IsSame(dsUserCommand_c* Obj);

	DSRESULT GetApiID(dsString* Uuid);
	DSRESULT get_Name(dsString* Val);
	DSRESULT put_Name(const dsString& NewVal);
	DSRESULT get_CommandString(dsString* Val);
	DSRESULT put_CommandString(const dsString& NewVal);
	DSRESULT GetID(dsString* UserCmdID);
};
