//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsViewManager_c.h, C++ API dsViewManager_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsDoubleArray.h"
#include "dsStringArray.h"

class dsViewManager_p;
class dsViewManager;
class dsModelNamedView_c;
class dsSheetNamedView_c;

class dsSolidBackground_c;
class dsGradientBackground_c;
class dsImageBackground_c;
class dsColor_c;
class DSINTERFACE_EXPORT dsViewManager_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsViewManager)
public:
	DSRESULT IsSame(dsViewManager_c* dsObj);

	DSRESULT GetModelNamedViewList(dsStringArray * ViewNamesStrArray);
	DSRESULT GetSheetNamedViewList(dsStringArray * ViewNamesStrArray);
	DSRESULT GetModelNamedView(const dsString&  Name, dsModelNamedView_c ** NamedView);
	DSRESULT GetSheetNamedView(const dsString&  Name, dsSheetNamedView_c ** NamedView);
	DSRESULT ActivateModelView(const dsString&  Name);
	DSRESULT ActivateSheetView(const dsString&  Name);
	DSRESULT SaveCurrentViewAsModelView(const dsString&  Name, const dsString&  Class, dsModelNamedView_c ** NamedView, dsCreateObjectResult_e* Result);
	DSRESULT SaveCurrentViewAsSheetView(const dsString&  Name, const dsString&  Class, dsSheetNamedView_c ** NamedView, dsCreateObjectResult_e* Result);
	DSRESULT CreateModelNamedView(const dsString&  Name, const dsString&  Class, const dsDoubleArray&  FirstCornerDblArray , const dsDoubleArray&  OppositeCornerDblArray , dsModelNamedView_c  ** NamedView, dsCreateObjectResult_e* Result);
	DSRESULT CreateSheetNamedView(const dsString&  Name, const dsString&  Class, const dsDoubleArray&  FirstCornerDblArray, const dsDoubleArray&  OppositeCornerDblArray, dsSheetNamedView_c ** NamedView, dsCreateObjectResult_e* Result);
	DSRESULT SetPredefinedView(dsPredefinedView_e PredefinedView);
	DSRESULT CreateSolidBackground(dsColor_c * SolidColor, dsSolidBackground_c ** SolidBackground);
	DSRESULT CreateGradientBackground(dsColor_c * TopColor, dsColor_c * MiddleColor, dsColor_c * BottomColor, bool  UseTwoColors, double  Angle, dsGradientBackground_c ** GradientBackground);
	DSRESULT CreateImageBackground(const dsString&  FileName, dsImageBackgroundPosition_e  Position, double  OffsetX, double  OffsetY, double  ScaleX, double  ScaleY, dsImageBackground_c ** ImageBackground);
	DSRESULT RemoveModelNamedView(dsModelNamedView_c * NamedView, bool * Result);
	DSRESULT RemoveSheetNamedView(dsSheetNamedView_c * NamedView, bool * Result);
};
