/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.util.TGClassLoader;
import org.herac.tuxguitar.resource.TGResourceManager;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.resource.UIImage;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGLibraryLoader;
import org.herac.tuxguitar.util.TGVersion;

public class TGFileUtils {
    private static final String FILE_SCHEME = "file";
    private static final String TG_HOME_PATH = "tuxguitar.home.path";
    private static final String TG_CONFIG_PATH = "tuxguitar.config.path";
    private static final String TG_SHARE_PATH = "tuxguitar.share.path";
    private static final String TG_USER_SHARE_PATH = "tuxguitar.user-share.path";
    private static final String TG_CLASS_PATH = "tuxguitar.class.path";
    private static final String TG_LIBRARY_PATH = "tuxguitar.library.path";
    private static final String TG_LIBRARY_PREFIX = "tuxguitar.library.prefix";
    private static final String TG_LIBRARY_EXTENSION = "tuxguitar.library.extension";
    public static final String PATH_HOME = TGFileUtils.getHomePath();
    public static final String PATH_USER_DIR = TGFileUtils.getDefaultUserAppDir();
    public static final String PATH_USER_CONFIG = TGFileUtils.getUserConfigDir();
    public static final String PATH_USER_PLUGINS_CONFIG = TGFileUtils.getUserPluginsConfigDir();
    public static final String PATH_USER_SHARE_PATH = TGFileUtils.getUserSharedPath();
    public static final String[] TG_STATIC_SHARED_PATHS = TGFileUtils.getStaticSharedPaths();

    public static void loadClasspath(TGContext context) {
        try {
            TGClassLoader.getInstance(context).setFilePaths(TG_STATIC_SHARED_PATHS);
            Enumeration plugins = TGResourceManager.getInstance((TGContext)context).getResources("plugins");
            while (plugins.hasMoreElements()) {
                URL url = (URL)plugins.nextElement();
                TGClassLoader.getInstance(context).addPaths(new File(TGFileUtils.getUrlPath(url)));
            }
            String custompath = System.getProperty(TG_CLASS_PATH);
            if (custompath != null) {
                String[] paths = custompath.split(File.pathSeparator);
                for (int i = 0; i < paths.length; ++i) {
                    TGClassLoader.getInstance(context).addPaths(new File(paths[i]));
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void loadLibraries(TGContext context) {
        String libraryPath = System.getProperty(TG_LIBRARY_PATH);
        if (libraryPath != null) {
            String[] libraryPaths = libraryPath.split(File.pathSeparator);
            String libraryPrefix = System.getProperty(TG_LIBRARY_PREFIX);
            String libraryExtension = System.getProperty(TG_LIBRARY_EXTENSION);
            for (int i = 0; i < libraryPaths.length; ++i) {
                TGLibraryLoader.getInstance((TGContext)context).loadLibraries(new File(libraryPaths[i]), libraryPrefix, libraryExtension);
            }
        }
    }

    private static String getResourcePath(TGContext context, String resource) {
        try {
            URL url = TGResourceManager.getInstance((TGContext)context).getResource(resource);
            if (url != null) {
                return TGFileUtils.getUrlPath(url);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public static String[] getFileNames(TGContext context, String resource) {
        try {
            File file;
            String path = TGFileUtils.getResourcePath(context, resource);
            if (path != null && TGFileUtils.isExistentAndReadable(file = new File(path)) && TGFileUtils.isDirectoryAndReadable(file)) {
                return file.list();
            }
            InputStream stream = TGResourceManager.getInstance((TGContext)context).getResourceAsStream(resource + "/list.properties");
            if (stream != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                ArrayList<String> fileNameList = new ArrayList<String>();
                String fileName = null;
                while ((fileName = reader.readLine()) != null) {
                    fileNameList.add(fileName);
                }
                String[] fileNames = new String[fileNameList.size()];
                for (int i = 0; i < fileNames.length; ++i) {
                    fileNames[i] = (String)fileNameList.get(i);
                }
                return fileNames;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public static UIImage loadImage(TGContext context, String skin, String name) {
        UIFactory uiFactory = TGApplication.getInstance(context).getFactory();
        try {
            InputStream stream = TGResourceManager.getInstance((TGContext)context).getResourceAsStream("skins/" + skin + "/" + name);
            if (stream != null) {
                return uiFactory.createImage(stream);
            }
            System.err.println(name + ": not found");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return uiFactory.createImage(16.0f, 16.0f);
    }

    public static boolean isLocalFile(URL url) {
        try {
            if (url.getProtocol().equals(new File(url.getFile()).toURI().toURL().getProtocol())) {
                return true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    public static boolean isLocalFile(URI uri) {
        try {
            if (uri.isAbsolute() && !uri.isOpaque() && FILE_SCHEME.equals(uri.getScheme())) {
                return true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    public static String getDecodedFileName(URI uri) {
        return !uri.isOpaque() ? TGFileUtils.getDecodedFileName(uri.getPath()) : null;
    }

    public static String getDecodedFileName(URL url) {
        return TGFileUtils.getDecodedFileName(url.getFile());
    }

    public static String getDecodedFileName(String fileName) {
        return TGFileUtils.getDecodedPath(new File(fileName).getName());
    }

    public static String getDecodedPath(String path) {
        try {
            return URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getHomePath() {
        File file;
        String homePath = System.getProperty(TG_HOME_PATH);
        if (homePath != null && TGFileUtils.isExistentAndReadable(file = new File(homePath).getAbsoluteFile()) && TGFileUtils.isDirectoryAndReadable(file)) {
            return file.getAbsolutePath();
        }
        homePath = System.getProperty("user.dir");
        if (homePath != null && TGFileUtils.isExistentAndReadable(file = new File(homePath).getAbsoluteFile()) && TGFileUtils.isDirectoryAndReadable(file)) {
            return file.getAbsolutePath();
        }
        return new File(".").getAbsolutePath();
    }

    private static String getDefaultUserAppDir() {
        return System.getProperty("user.home") + File.separator + ".tuxguitar-" + TGVersion.CURRENT.getVersion();
    }

    private static String getUserConfigDir() {
        File file;
        String configPath = System.getProperty(TG_CONFIG_PATH);
        if (configPath == null) {
            configPath = TGFileUtils.getDefaultUserAppDir() + File.separator + "config";
        }
        if (!TGFileUtils.isExistentAndReadable(file = new File(configPath))) {
            TGFileUtils.tryCreateDirectory(file);
        }
        return configPath;
    }

    private static String getUserPluginsConfigDir() {
        String configPluginsPath = TGFileUtils.getUserConfigDir() + File.separator + "plugins";
        File file = new File(configPluginsPath);
        if (!TGFileUtils.isExistentAndReadable(file)) {
            TGFileUtils.tryCreateDirectory(file);
        }
        return configPluginsPath;
    }

    private static String getUserSharedPath() {
        File file;
        String userSharePath = System.getProperty(TG_USER_SHARE_PATH);
        if (userSharePath == null) {
            userSharePath = TGFileUtils.getDefaultUserAppDir() + File.separator + "cache";
        }
        if (!TGFileUtils.isExistentAndReadable(file = new File(userSharePath))) {
            TGFileUtils.tryCreateDirectory(file);
        }
        return userSharePath;
    }

    private static String[] getStaticSharedPaths() {
        String staticSharedPaths = new String(PATH_USER_SHARE_PATH);
        String staticSharedPathsProperty = System.getProperty(TG_SHARE_PATH);
        if (staticSharedPathsProperty != null) {
            staticSharedPaths = staticSharedPaths + File.pathSeparator + staticSharedPathsProperty;
        }
        return staticSharedPaths.split(File.pathSeparator);
    }

    private static String getUrlPath(URL url) throws UnsupportedEncodingException {
        return new File(URLDecoder.decode(url.getPath(), "UTF-8")).getAbsolutePath() + File.separator;
    }

    public static boolean isExistentAndReadable(File file) {
        try {
            return file.exists();
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public static boolean isDirectoryAndReadable(File file) {
        try {
            return file.isDirectory();
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public static boolean tryCreateDirectory(File file) {
        try {
            return file.mkdirs();
        }
        catch (SecurityException se) {
            return false;
        }
    }
}

