/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.chord;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordCreatorListener;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordDatabase;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordNamingConvention;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordSettings;
import org.herac.tuxguitar.song.models.TGChord;

public class TGChordCreatorUtil {
    public static final int MAX_STRINGS = 7;
    public static final int MAX_FRET_SPAN = 5;
    private final int BASS_INDEX = -1;
    private final int ESSENTIAL_INDEX = -2;
    private final int NOT_ESSENTIAL_INDEX = -3;
    private static long runningProcess;
    private long processId;
    private TGChordCreatorListener listener;
    private int alteration;
    private int chordIndex;
    private int[] requiredNotes;
    private int[] expandingNotes;
    private int add5 = 0;
    private String chordName = null;
    private int bassTonic;
    private int chordTonic;
    private int[] tuning;

    private TGChordCreatorUtil(long processId, TGChordCreatorListener listener) {
        this.processId = processId;
        this.listener = listener;
    }

    public boolean isValidProcess() {
        return this.processId == runningProcess;
    }

    public static long getNewProcess() {
        return ++runningProcess;
    }

    public static void getChords(TGChordCreatorListener listener, final int[] tuning, final int chordIndex, final int alteration, final int plusMinus, final boolean add, final int add5, final int add9, final int add11, final int bassTonic, final int chordTonic, final boolean sharp) {
        final TGChordCreatorUtil chordCreator = new TGChordCreatorUtil(TGChordCreatorUtil.getNewProcess(), listener);
        new Thread(new Runnable(){

            @Override
            public void run() {
                chordCreator.getChords(tuning, chordIndex, alteration, plusMinus, add, add5, add9, add11, bassTonic, chordTonic, sharp);
            }
        }).start();
    }

    protected void getChords(int[] tuning, int chordIndex, int alteration, int plusMinus, boolean add, int add5, int add9, int add11, int bassTonic, int chordTonic, boolean sharp) {
        List<TGChord> chords;
        int i;
        if (!this.isValidProcess()) {
            return;
        }
        this.add5 = add5;
        this.tuning = tuning;
        this.chordIndex = chordIndex;
        this.chordTonic = chordTonic;
        this.bassTonic = bassTonic;
        this.alteration = alteration;
        this.chordName = new TGChordNamingConvention().createChordName(this.chordTonic, this.chordIndex, this.alteration, plusMinus, add, add5, add9, add11, this.bassTonic, sharp);
        if (this.alteration != 0) {
            if (add) {
                this.expandingNotes = new int[1];
                this.expandingNotes[0] = this.getAddNote(this.alteration - 1, plusMinus);
            } else {
                this.expandingNotes = new int[1 + this.alteration];
                this.expandingNotes[0] = 11;
                this.expandingNotes[1] = this.getAddNote(this.alteration - 1, plusMinus);
                for (i = 2; i <= this.alteration; ++i) {
                    this.expandingNotes[i] = this.getAddNote(i - 2, i == 2 ? add9 : add11);
                }
            }
        } else {
            this.expandingNotes = new int[0];
        }
        this.requiredNotes = TGChordDatabase.get(chordIndex).cloneRequireds();
        if (add5 != 0) {
            for (i = 0; i < this.requiredNotes.length; ++i) {
                if (this.requiredNotes[i] != 8) continue;
                int n = i;
                this.requiredNotes[n] = this.requiredNotes[n] + (add5 == 1 ? 1 : -1);
            }
        }
        int count = 0;
        for (int i2 = 0; i2 < this.requiredNotes.length; ++i2) {
            this.requiredNotes[i2] = this.checkForOverlapping(this.requiredNotes[i2]);
            if (this.requiredNotes[i2] == -1) continue;
            ++count;
        }
        int[] tempNotes = new int[count];
        count = 0;
        for (int i3 = 0; i3 < this.requiredNotes.length; ++i3) {
            if (this.requiredNotes[i3] == -1) continue;
            tempNotes[count] = this.requiredNotes[i3];
            ++count;
        }
        this.requiredNotes = tempNotes;
        if (this.isValidProcess() && (chords = this.getChords()) != null && this.isValidProcess()) {
            this.listener.notifyChords(this, chords);
        }
    }

    protected int checkForOverlapping(int checkIt) {
        for (int i = 0; i < this.expandingNotes.length; ++i) {
            if (this.expandingNotes[i] != checkIt) continue;
            return -1;
        }
        return checkIt;
    }

    private List<TGChord> getChords() {
        if (!this.isValidProcess()) {
            return null;
        }
        List<List<StringValue>> potentialNotes = this.makePotentialNotes();
        List<List<StringValue>> combinations = this.makeCombinations(potentialNotes);
        List<PriorityItem> priorities = this.determinePriority(combinations);
        List<List<StringValue>> theBestOnes = this.takeBest(priorities);
        return this.createChords(theBestOnes);
    }

    private List<TGChord> createChords(List<List<StringValue>> top) {
        if (!this.isValidProcess()) {
            return null;
        }
        ArrayList<TGChord> chords = new ArrayList<TGChord>(top.size());
        Iterator<List<StringValue>> it = top.iterator();
        while (it.hasNext()) {
            TGChord chord = TuxGuitar.getInstance().getSongManager().getFactory().newChord(this.tuning.length);
            for (StringValue stringValue : it.next()) {
                int string = chord.getStrings().length - 1 - stringValue.getString();
                int fret = stringValue.getFret();
                chord.addFretValue(string, fret);
                chord.setName(this.chordName);
            }
            chords.add(chord);
        }
        return chords;
    }

    private void find(int stringTone, int stringIndex, int fret, List<StringValue> stringList) {
        int i;
        if (!this.isValidProcess()) {
            return;
        }
        boolean bassAlreadyIn = false;
        for (i = 0; i < this.requiredNotes.length; ++i) {
            if ((stringTone + fret) % 12 != (this.chordTonic + this.requiredNotes[i] - 1) % 12) continue;
            if (!bassAlreadyIn && (stringTone + fret) % 12 == this.bassTonic) {
                bassAlreadyIn = true;
            }
            stringList.add(new StringValue(stringIndex, fret, i));
            return;
        }
        if (this.expandingNotes.length != 0) {
            for (i = 0; i < this.expandingNotes.length; ++i) {
                if ((stringTone + fret) % 12 != (this.chordTonic + this.expandingNotes[i] - 1) % 12) continue;
                if (!bassAlreadyIn && (stringTone + fret) % 12 == this.bassTonic) {
                    bassAlreadyIn = true;
                }
                stringList.add(new StringValue(stringIndex, fret, i < 2 ? this.ESSENTIAL_INDEX : this.NOT_ESSENTIAL_INDEX));
            }
        }
        if (!bassAlreadyIn && (stringTone + fret) % 12 == this.bassTonic) {
            stringList.add(new StringValue(stringIndex, fret, this.BASS_INDEX));
            return;
        }
    }

    private int getAddNote(int type, int selectionIndex) {
        int wantedNote = 0;
        switch (type) {
            case 0: {
                wantedNote = 3;
                break;
            }
            case 1: {
                wantedNote = 6;
                break;
            }
            case 2: {
                wantedNote = 10;
            }
        }
        switch (selectionIndex) {
            case 1: {
                ++wantedNote;
                break;
            }
            case 2: {
                --wantedNote;
                break;
            }
        }
        return wantedNote;
    }

    private List<List<StringValue>> makePotentialNotes() {
        if (!this.isValidProcess()) {
            return null;
        }
        ArrayList<List<StringValue>> potentialNotes = new ArrayList<List<StringValue>>(this.tuning.length);
        for (int string = 0; string < this.tuning.length; ++string) {
            ArrayList<StringValue> currentStringList = new ArrayList<StringValue>(10);
            if (TGChordSettings.instance().getFindChordsMin() > 0 && TGChordSettings.instance().isEmptyStringChords()) {
                this.find(this.tuning[string], string, 0, currentStringList);
            }
            for (int fret = TGChordSettings.instance().getFindChordsMin(); fret <= TGChordSettings.instance().getFindChordsMax(); ++fret) {
                this.find(this.tuning[string], string, fret, currentStringList);
            }
            potentialNotes.add(currentStringList);
        }
        return potentialNotes;
    }

    private List<List<StringValue>> makeCombinations(List<List<StringValue>> potentialNotes) {
        if (!this.isValidProcess()) {
            return null;
        }
        ArrayList<List<Integer>> stringCombination = new ArrayList<List<Integer>>(60);
        List<List<Integer>> lastLevelCombination = null;
        for (int i = 0; i < this.tuning.length - 1; ++i) {
            lastLevelCombination = this.makeStringCombination(lastLevelCombination);
            stringCombination.addAll(lastLevelCombination);
        }
        ArrayList<List<StringValue>> combinations = new ArrayList<List<StringValue>>(800);
        for (List list : stringCombination) {
            List<List<StringValue>> lastStringValueCombination = null;
            for (int level = 0; level < list.size(); ++level) {
                int currentString = (Integer)list.get(level);
                lastStringValueCombination = this.makeStringValueCombination(lastStringValueCombination, potentialNotes.get(currentString));
            }
            if (lastStringValueCombination == null) continue;
            combinations.addAll(lastStringValueCombination);
        }
        return combinations;
    }

    private List<List<Integer>> makeStringCombination(List<List<Integer>> lastLevelCombinationRef) {
        if (!this.isValidProcess()) {
            return null;
        }
        List<List<Integer>> lastLevelCombination = lastLevelCombinationRef;
        if (lastLevelCombination == null) {
            lastLevelCombination = new ArrayList<List<Integer>>();
            for (int i = 0; i < this.tuning.length; ++i) {
                lastLevelCombination.add(new ArrayList());
                lastLevelCombination.get(i).add(new Integer(i));
            }
        }
        ArrayList<List<Integer>> thisLevelCombination = new ArrayList<List<Integer>>();
        for (int current = 1; current < this.tuning.length; ++current) {
            for (List<Integer> combination : lastLevelCombination) {
                Integer currentInteger = new Integer(current);
                if (combination.get(combination.size() - 1) >= current || combination.contains(currentInteger)) continue;
                List newCombination = (List)((ArrayList)combination).clone();
                newCombination.add(currentInteger);
                thisLevelCombination.add(newCombination);
            }
        }
        return thisLevelCombination;
    }

    private List<List<StringValue>> makeStringValueCombination(List<List<StringValue>> lastLevelCombination, List<StringValue> notes) {
        if (!this.isValidProcess()) {
            return null;
        }
        ArrayList<List<StringValue>> thisLevelCombination = null;
        if (lastLevelCombination == null) {
            thisLevelCombination = new ArrayList(notes.size());
            for (int i = 0; i < notes.size(); ++i) {
                thisLevelCombination.add(new ArrayList(6));
                ((List)thisLevelCombination.get(i)).add(notes.get(i));
            }
        } else {
            thisLevelCombination = new ArrayList<List<StringValue>>();
            for (int i = 0; i < notes.size(); ++i) {
                for (int j = 0; j < lastLevelCombination.size(); ++j) {
                    List currentCombination = (List)((ArrayList)lastLevelCombination.get(j)).clone();
                    currentCombination.add(notes.get(i));
                    if (!this.checkCombination(currentCombination)) continue;
                    thisLevelCombination.add(currentCombination);
                }
            }
        }
        return thisLevelCombination;
    }

    private boolean checkCombination(List<StringValue> combination) {
        int maxRight;
        Iterator<StringValue> it = combination.iterator();
        int maxLeft = maxRight = combination.get(0).getFret();
        while (it.hasNext()) {
            int fret = it.next().getFret();
            if (fret == 0 && TGChordSettings.instance().isEmptyStringChords()) continue;
            if (fret < maxLeft) {
                maxLeft = fret;
            }
            if (fret <= maxRight) continue;
            maxRight = fret;
        }
        return Math.abs(maxLeft - maxRight) < 5;
    }

    private List<PriorityItem> determinePriority(List<List<StringValue>> allCombinations) {
        if (!this.isValidProcess()) {
            return null;
        }
        ArrayList<PriorityItem> ordered = new ArrayList<PriorityItem>();
        Iterator<List<StringValue>> it = allCombinations.iterator();
        while (it.hasNext() && this.isValidProcess()) {
            float priority = 0.0f;
            List<StringValue> stringValueCombination = it.next();
            priority += this.combinationHasAllRequiredNotes(stringValueCombination);
            priority += this.combinationChordSemantics(stringValueCombination);
            priority += this.combinationHasSubsequentStrings(stringValueCombination);
            priority = (float)((double)(priority += this.combinationBassInBass(stringValueCombination)) + (double)(TGChordSettings.instance().getManyStringsGrade() / 3.0f) * ((double)stringValueCombination.size() - (double)this.tuning.length / (TGChordSettings.instance().getManyStringsGrade() > 0.0f ? 2.0 : 1.2)));
            PriorityItem item = new PriorityItem();
            item.priority = priority += this.combinationHasGoodFingering(stringValueCombination);
            item.stringValues = stringValueCombination;
            ordered.add(item);
        }
        return ordered;
    }

    private List<List<StringValue>> takeBest(List<PriorityItem> priorityItems) {
        if (!this.isValidProcess()) {
            return null;
        }
        int maximum = TGChordSettings.instance().getChordsToDisplay();
        ArrayList<List<StringValue>> bestOnes = new ArrayList<List<StringValue>>(maximum);
        Collections.sort(priorityItems, new PriorityComparator());
        for (int i = 0; i < priorityItems.size() && this.isValidProcess(); ++i) {
            PriorityItem item = priorityItems.get(i);
            if (this.checkIfSubset(item.stringValues, bestOnes)) continue;
            bestOnes.add(item.stringValues);
            if (bestOnes.size() >= maximum) break;
        }
        return bestOnes;
    }

    private float combinationHasAllRequiredNotes(List<StringValue> stringValueCombination) {
        if (!this.isValidProcess()) {
            return 0.0f;
        }
        Iterator<StringValue> it = stringValueCombination.iterator();
        int[] values = new int[this.requiredNotes.length];
        int currentIndex = 0;
        while (it.hasNext()) {
            StringValue sv = it.next();
            if (sv.getRequiredNoteIndex() < 0) continue;
            boolean insert = true;
            for (int i = 0; i < currentIndex; ++i) {
                if (values[i] != sv.getRequiredNoteIndex() + 1) continue;
                insert = false;
            }
            if (!insert) continue;
            values[currentIndex] = sv.getRequiredNoteIndex() + 1;
            ++currentIndex;
        }
        if (currentIndex == this.requiredNotes.length) {
            return TGChordSettings.instance().getRequiredBasicsGrade();
        }
        if (currentIndex == this.requiredNotes.length - 1) {
            boolean existsSubdominant = false;
            for (StringValue current : stringValueCombination) {
                if ((this.tuning[current.getString()] + current.getFret()) % 12 != (this.chordTonic + 7) % 12) continue;
                existsSubdominant = true;
            }
            if (!existsSubdominant && currentIndex == this.requiredNotes.length - 1 && TGChordDatabase.get(this.chordIndex).getName().indexOf("sus") >= 0 && this.requiredNotes.length != 2 && this.add5 == 0) {
                return TGChordSettings.instance().getRequiredBasicsGrade() * 4.0f / 5.0f;
            }
        }
        int noteCount = (this.alteration == 0 ? 0 : 1 + this.alteration) + currentIndex + (this.bassTonic == this.chordTonic ? 0 : 1);
        return -TGChordSettings.instance().getRequiredBasicsGrade() * (float)(this.tuning.length - noteCount) / (float)this.tuning.length * 2.0f;
    }

    private float combinationHasSubsequentStrings(List<StringValue> stringValueCombination) {
        if (!this.isValidProcess()) {
            return 0.0f;
        }
        boolean stumbled = false;
        boolean noMore = false;
        boolean penalty = false;
        for (int i = 0; i < this.tuning.length; ++i) {
            boolean found = false;
            Iterator<StringValue> it = stringValueCombination.iterator();
            while (it.hasNext()) {
                if (it.next().getString() != i) continue;
                found = true;
            }
            if (found) {
                if (!stumbled) {
                    stumbled = true;
                }
                if (noMore) {
                    penalty = true;
                }
                if (!penalty) continue;
                return -TGChordSettings.instance().getSubsequentGrade();
            }
            if (!stumbled) continue;
            noMore = true;
        }
        if (penalty) {
            return 0.0f;
        }
        return TGChordSettings.instance().getSubsequentGrade();
    }

    private float combinationBassInBass(List<StringValue> stringValueCombination) {
        if (!this.isValidProcess()) {
            return 0.0f;
        }
        for (int i = 0; i < this.tuning.length; ++i) {
            for (StringValue sv : stringValueCombination) {
                if (sv.getString() != i) continue;
                if ((this.tuning[sv.getString()] + sv.getFret()) % 12 == this.bassTonic) {
                    return TGChordSettings.instance().getBassGrade();
                }
                return -TGChordSettings.instance().getBassGrade();
            }
        }
        return 0.0f;
    }

    private float combinationHasGoodFingering(List<StringValue> stringValueCombination) {
        int i;
        float distanceGrade;
        if (!this.isValidProcess()) {
            return 0.0f;
        }
        float finalGrade = 0.0f;
        int[] positions = new int[this.tuning.length];
        for (int i2 = 0; i2 < this.tuning.length; ++i2) {
            positions[i2] = -1;
        }
        for (StringValue sv : stringValueCombination) {
            positions[sv.getString()] = sv.getFret();
        }
        int min = TGChordSettings.instance().getFindChordsMax() + 2;
        int max = 0;
        int maxCount = 0;
        boolean openChord = false;
        boolean zeroString = false;
        for (int i3 = 0; i3 < this.tuning.length; ++i3) {
            openChord |= TGChordSettings.instance().isEmptyStringChords() && positions[i3] == 0;
            zeroString |= positions[i3] == 0;
            if (positions[i3] < min && positions[i3] != 0 && positions[i3] != -1) {
                min = positions[i3];
            }
            if (positions[i3] > max) {
                max = positions[i3];
                maxCount = 1;
                continue;
            }
            if (positions[i3] != max) continue;
            ++maxCount;
        }
        int count = 0;
        for (int i4 = 0; i4 < this.tuning.length; ++i4) {
            if (positions[i4] != min) continue;
            ++count;
        }
        if (!openChord) {
            if (zeroString) {
                finalGrade += TGChordSettings.instance().getFingeringGrade() / 8.0f;
            } else if (count >= 2) {
                finalGrade += TGChordSettings.instance().getFingeringGrade() / 8.0f;
            }
        } else if (openChord) {
            finalGrade += TGChordSettings.instance().getFingeringGrade() / 8.0f;
        }
        switch (Math.abs(max - min)) {
            case 0: {
                distanceGrade = TGChordSettings.instance().getFingeringGrade() / 5.0f;
                break;
            }
            case 1: {
                distanceGrade = TGChordSettings.instance().getFingeringGrade() / (float)(5 + maxCount);
                break;
            }
            case 2: {
                distanceGrade = TGChordSettings.instance().getFingeringGrade() / (float)(6 + maxCount);
                if (min >= 5) break;
                distanceGrade = (float)((double)distanceGrade * 0.9);
                break;
            }
            case 3: {
                distanceGrade = -TGChordSettings.instance().getFingeringGrade() / 10.0f * (float)maxCount;
                if (min >= 5) break;
                distanceGrade = (float)((double)distanceGrade * 1.3);
                break;
            }
            case 4: {
                distanceGrade = -TGChordSettings.instance().getFingeringGrade() / 4.0f * (float)maxCount;
                if (min > 5) break;
                distanceGrade = (float)((double)distanceGrade * 1.8);
                break;
            }
            default: {
                distanceGrade = -TGChordSettings.instance().getFingeringGrade() * (float)maxCount;
            }
        }
        finalGrade += distanceGrade;
        List[] fingers = new List[]{new ArrayList(2), new ArrayList(2), new ArrayList(2), new ArrayList(2)};
        int lastZeroIndex = 0;
        if (zeroString) {
            for (i = 0; i < positions.length; ++i) {
                if (positions[i] != 0) continue;
                lastZeroIndex = i;
            }
        }
        fingers[0].add(new Integer(min));
        for (i = lastZeroIndex; i < positions.length; ++i) {
            if (positions[i] != min) continue;
            fingers[0].add(new Integer(i));
            positions[i] = -1;
        }
        int finger = 1;
        for (int i5 = 0; i5 < positions.length; ++i5) {
            if (positions[i5] == 0 || positions[i5] == -1) continue;
            if (finger < 4) {
                fingers[finger].add(new Integer(positions[i5]));
                fingers[finger].add(new Integer(i5));
                positions[i5] = -1;
            }
            ++finger;
        }
        finalGrade = finger > 4 ? (finalGrade -= TGChordSettings.instance().getFingeringGrade()) : (float)((double)finalGrade + (double)TGChordSettings.instance().getFingeringGrade() * 0.1 * (double)(15 - 2 * finger));
        return finalGrade;
    }

    private float combinationChordSemantics(List<StringValue> stringValueCombination) {
        if (!this.isValidProcess()) {
            return 0.0f;
        }
        float finalGrade = 0.0f;
        int foundTonic = -1;
        int[] foundExpanding = new int[this.expandingNotes.length];
        int stringDepth = 0;
        for (int string = 0; string < this.tuning.length; ++string) {
            Iterator<StringValue> it = stringValueCombination.iterator();
            StringValue current = null;
            boolean found = false;
            while (it.hasNext() && !found) {
                StringValue sv = it.next();
                if (sv.getString() != string || found || sv.getFret() == -1) continue;
                current = sv;
                found = true;
                ++stringDepth;
            }
            if (current == null) continue;
            if (foundTonic == -1 && current.getRequiredNoteIndex() == 0) {
                foundTonic = this.tuning[current.getString()] + current.getFret();
            }
            if (stringDepth <= true) continue;
            if (current.getRequiredNoteIndex() == this.BASS_INDEX) {
                finalGrade -= TGChordSettings.instance().getGoodChordSemanticsGrade();
            }
            if (current.getRequiredNoteIndex() >= 0) continue;
            if (foundTonic == -1) {
                finalGrade -= TGChordSettings.instance().getGoodChordSemanticsGrade() / 2.0f;
            } else if (foundTonic + 11 > this.tuning[current.getString()] + current.getFret()) {
                finalGrade -= TGChordSettings.instance().getGoodChordSemanticsGrade() / 3.0f;
            }
            for (int i = 0; i < this.expandingNotes.length; ++i) {
                if ((this.tuning[string] + current.getFret()) % 12 != (this.chordTonic + this.expandingNotes[i] - 1) % 12 || foundExpanding[i] != 0) continue;
                foundExpanding[i] = current.getRequiredNoteIndex();
            }
        }
        if (this.alteration != 0) {
            int essentials = 0;
            int nonEssentials = 0;
            for (int i = 0; i < foundExpanding.length; ++i) {
                if (foundExpanding[i] == this.ESSENTIAL_INDEX) {
                    ++essentials;
                    continue;
                }
                if (foundExpanding[i] == 0) continue;
                ++nonEssentials;
            }
            if (essentials + nonEssentials == this.expandingNotes.length) {
                finalGrade += TGChordSettings.instance().getGoodChordSemanticsGrade();
            } else if (essentials == 2) {
                finalGrade += TGChordSettings.instance().getGoodChordSemanticsGrade() / 2.0f;
            } else {
                finalGrade += (float)(essentials + nonEssentials - this.expandingNotes.length) * TGChordSettings.instance().getGoodChordSemanticsGrade();
                finalGrade += (float)nonEssentials * TGChordSettings.instance().getGoodChordSemanticsGrade() / 2.0f;
            }
        }
        return finalGrade;
    }

    private boolean checkIfSubset(List<StringValue> stringValues, List<List<StringValue>> betterOnes) {
        if (!this.isValidProcess()) {
            return false;
        }
        for (List<StringValue> currentStringValue : betterOnes) {
            boolean foundDifferentFret = false;
            for (int i = 0; i < currentStringValue.size(); ++i) {
                int currentString = currentStringValue.get(i).getString();
                for (int j = 0; j < stringValues.size(); ++j) {
                    if (stringValues.get(j).getString() != currentString || stringValues.get(j).getFret() == currentStringValue.get(i).getFret()) continue;
                    foundDifferentFret = true;
                }
            }
            if (foundDifferentFret) continue;
            return true;
        }
        return false;
    }

    protected class PriorityComparator
    implements Comparator<PriorityItem> {
        protected PriorityComparator() {
        }

        @Override
        public int compare(PriorityItem o1, PriorityItem o2) {
            return Math.round(o2.priority - o1.priority);
        }
    }

    protected class PriorityItem {
        List<StringValue> stringValues;
        float priority;

        protected PriorityItem() {
        }
    }

    private class StringValue {
        protected int string;
        protected int fret;
        protected int requiredNoteIndex;

        public StringValue(int string, int fret, int requiredNoteIndex) {
            this.string = string;
            this.fret = fret;
            this.requiredNoteIndex = requiredNoteIndex;
        }

        public int getString() {
            return this.string;
        }

        public int getFret() {
            return this.fret;
        }

        public int getRequiredNoteIndex() {
            return this.requiredNoteIndex;
        }
    }
}

