/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.printer;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.dialog.printer.TGPrintSettingsHandler;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.graphics.control.print.TGPrintSettings;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICheckBox;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UISpinner;
import org.herac.tuxguitar.ui.widget.UIWindow;

public class TGPrintSettingsDialog {
    public static final String ATTRIBUTE_HANDLER = TGPrintSettingsHandler.class.getName();

    public void show(TGViewContext context) {
        TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        final TGPrintSettingsHandler handler = (TGPrintSettingsHandler)context.getAttribute(ATTRIBUTE_HANDLER);
        UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("options"));
        UITableLayout trackLayout = new UITableLayout();
        UILegendPanel track = uiFactory.createLegendPanel((UIContainer)dialog);
        track.setLayout((UILayout)trackLayout);
        track.setText(TuxGuitar.getProperty("track"));
        dialogLayout.set((UIControl)track, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(300.0f), null, null);
        final UILabel trackLabel = uiFactory.createLabel((UIContainer)track);
        trackLabel.setText(TuxGuitar.getProperty("track"));
        trackLayout.set((UIControl)trackLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UIDropDownSelect trackCombo = uiFactory.createDropDownSelect((UIContainer)track);
        for (int number = 1; number <= song.countTracks(); ++number) {
            trackCombo.addItem(new UISelectItem(TuxGuitar.getInstance().getSongManager().getTrack(song, number).getName(), (Object)number));
        }
        trackCombo.setSelectedValue((Object)TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getTrack().getNumber());
        trackLayout.set((UIControl)trackCombo, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UICheckBox trackAllCheck = uiFactory.createCheckBox((UIContainer)track);
        trackAllCheck.setText(TuxGuitar.getProperty("edit.all-tracks"));
        trackAllCheck.setSelected(false);
        trackAllCheck.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                trackLabel.setEnabled(!trackAllCheck.isSelected());
                trackCombo.setEnabled(!trackAllCheck.isSelected());
            }
        });
        trackLayout.set((UIControl)trackAllCheck, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2));
        UITableLayout rangeLayout = new UITableLayout();
        UILegendPanel range = uiFactory.createLegendPanel((UIContainer)dialog);
        range.setLayout((UILayout)rangeLayout);
        range.setText(TuxGuitar.getProperty("print.range"));
        dialogLayout.set((UIControl)range, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(300.0f), null, null);
        boolean minSelection = true;
        final int maxSelection = song.countMeasureHeaders();
        UILabel fromLabel = uiFactory.createLabel((UIContainer)range);
        fromLabel.setText(TuxGuitar.getProperty("edit.from"));
        rangeLayout.set((UIControl)fromLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UISpinner fromSpinner = uiFactory.createSpinner((UIContainer)range);
        fromSpinner.setMaximum(maxSelection);
        fromSpinner.setMinimum(1);
        fromSpinner.setValue(1);
        rangeLayout.set((UIControl)fromSpinner, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(60.0f), null, null);
        UILabel toLabel = uiFactory.createLabel((UIContainer)range);
        toLabel.setText(TuxGuitar.getProperty("edit.to"));
        rangeLayout.set((UIControl)toLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UISpinner toSpinner = uiFactory.createSpinner((UIContainer)range);
        toSpinner.setMinimum(1);
        toSpinner.setMaximum(maxSelection);
        toSpinner.setValue(maxSelection);
        rangeLayout.set((UIControl)toSpinner, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(60.0f), null, null);
        fromSpinner.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                int fromSelection = fromSpinner.getValue();
                int toSelection = toSpinner.getValue();
                if (fromSelection < 1) {
                    fromSpinner.setValue(1);
                } else if (fromSelection > toSelection) {
                    fromSpinner.setValue(toSelection);
                }
            }
        });
        toSpinner.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                int fromSelection;
                int toSelection = toSpinner.getValue();
                if (toSelection < (fromSelection = fromSpinner.getValue())) {
                    toSpinner.setValue(fromSelection);
                } else if (toSelection > maxSelection) {
                    toSpinner.setValue(maxSelection);
                }
            }
        });
        UITableLayout optionsLayout = new UITableLayout();
        UILegendPanel options = uiFactory.createLegendPanel((UIContainer)dialog);
        options.setLayout((UILayout)optionsLayout);
        options.setText(TuxGuitar.getProperty("options"));
        dialogLayout.set((UIControl)options, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(300.0f), null, null);
        final UICheckBox tablatureEnabled = uiFactory.createCheckBox((UIContainer)options);
        tablatureEnabled.setText(TuxGuitar.getProperty("export.tablature-enabled"));
        tablatureEnabled.setSelected(true);
        optionsLayout.set((UIControl)tablatureEnabled, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UICheckBox scoreEnabled = uiFactory.createCheckBox((UIContainer)options);
        scoreEnabled.setText(TuxGuitar.getProperty("export.score-enabled"));
        scoreEnabled.setSelected(true);
        optionsLayout.set((UIControl)scoreEnabled, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UICheckBox chordNameEnabled = uiFactory.createCheckBox((UIContainer)options);
        chordNameEnabled.setText(TuxGuitar.getProperty("export.chord-name-enabled"));
        chordNameEnabled.setSelected(true);
        optionsLayout.set((UIControl)chordNameEnabled, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UICheckBox chordDiagramEnabled = uiFactory.createCheckBox((UIContainer)options);
        chordDiagramEnabled.setText(TuxGuitar.getProperty("export.chord-diagram-enabled"));
        chordDiagramEnabled.setSelected(true);
        optionsLayout.set((UIControl)chordDiagramEnabled, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UICheckBox blackAndWhite = uiFactory.createCheckBox((UIContainer)options);
        blackAndWhite.setText(TuxGuitar.getProperty("export.black-and-white"));
        blackAndWhite.setSelected(true);
        optionsLayout.set((UIControl)blackAndWhite, Integer.valueOf(5), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        tablatureEnabled.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (!tablatureEnabled.isSelected()) {
                    scoreEnabled.setSelected(true);
                }
            }
        });
        scoreEnabled.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (!scoreEnabled.isSelected()) {
                    tablatureEnabled.setSelected(true);
                }
            }
        });
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                int style = 0;
                style |= scoreEnabled.isSelected() ? 4 : 0;
                style |= tablatureEnabled.isSelected() ? 8 : 0;
                style |= chordNameEnabled.isSelected() ? 16 : 0;
                style |= chordDiagramEnabled.isSelected() ? 32 : 0;
                style |= blackAndWhite.isSelected() ? 64 : 0;
                Integer selectedTrack = !trackAllCheck.isSelected() ? (Integer)trackCombo.getSelectedValue() : null;
                TGPrintSettings printStyles = new TGPrintSettings();
                printStyles.setTrackNumber(selectedTrack != null ? selectedTrack : -1);
                printStyles.setFromMeasure(fromSpinner.getValue());
                printStyles.setToMeasure(toSpinner.getValue());
                printStyles.setStyle(style);
                dialog.dispose();
                handler.updatePrintSettings(printStyles);
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(dialog, 5);
    }
}

