/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.swt.printer;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.herac.tuxguitar.ui.printer.UIPrinter;
import org.herac.tuxguitar.ui.printer.UIPrinterJob;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.resource.UIResourceFactory;
import org.herac.tuxguitar.ui.swt.SWTComponent;
import org.herac.tuxguitar.ui.swt.printer.SWTPrinterJob;
import org.herac.tuxguitar.ui.swt.resource.SWTResourceFactory;

public class SWTPrinter
extends SWTComponent<Printer>
implements UIPrinter {
    private PrinterData data;
    private UIResourceFactory resourceFactory;

    public SWTPrinter(PrinterData data) {
        super(new Printer(data));
        this.data = data;
        this.resourceFactory = new SWTResourceFactory((Device)this.getControl());
    }

    public void dispose() {
        ((Printer)this.getControl()).dispose();
    }

    public boolean isDisposed() {
        return ((Printer)this.getControl()).isDisposed();
    }

    public UIResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public Float getDpiScale() {
        Point dpi = ((Printer)this.getControl()).getDPI();
        if (dpi != null) {
            return Float.valueOf((float)dpi.x / 100.0f);
        }
        return Float.valueOf(1.0f);
    }

    public UIRectangle getBounds() {
        Rectangle area = ((Printer)this.getControl()).getClientArea();
        return new UIRectangle((float)area.x, (float)area.y, (float)area.width, (float)area.height);
    }

    public Integer getStartPage() {
        return this.data.scope == 1 ? Integer.valueOf(this.data.startPage) : null;
    }

    public Integer getEndPage() {
        return this.data.scope == 1 ? Integer.valueOf(this.data.endPage) : null;
    }

    public UIPrinterJob createJob(String name) {
        return new SWTPrinterJob((Printer)this.getControl(), name);
    }
}

