/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.swt.widget;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.ui.event.UICloseListener;
import org.herac.tuxguitar.ui.menu.UIMenuBar;
import org.herac.tuxguitar.ui.resource.UIImage;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.swt.event.SWTCloseListenerManager;
import org.herac.tuxguitar.ui.swt.menu.SWTMenu;
import org.herac.tuxguitar.ui.swt.resource.SWTImage;
import org.herac.tuxguitar.ui.swt.widget.SWTContainer;
import org.herac.tuxguitar.ui.swt.widget.SWTLayoutContainer;
import org.herac.tuxguitar.ui.widget.UIWindow;

public class SWTWindow
extends SWTLayoutContainer<Shell>
implements UIWindow {
    private UIImage image;
    private UIMenuBar menuBar;
    private SWTCloseListenerManager closeListener = new SWTCloseListenerManager(this);
    private SWTWindowResizeListener resizeListener = new SWTWindowResizeListener(this);

    public SWTWindow(Shell shell, SWTContainer<? extends Composite> parent) {
        super(shell, parent);
        ((Shell)this.getControl()).addListener(11, (Listener)this.resizeListener);
    }

    public SWTWindow(Display display) {
        this(new Shell(display), (SWTContainer<? extends Composite>)null);
    }

    public SWTWindow(SWTWindow parent, boolean modal, boolean resizable) {
        this(new Shell((Shell)parent.getControl(), 0x860 | (modal ? 65536 : 0) | (resizable ? 1040 : 0)), (SWTContainer<? extends Composite>)parent);
    }

    public String getText() {
        return ((Shell)this.getControl()).getText();
    }

    public void setText(String text) {
        ((Shell)this.getControl()).setText(text);
    }

    public UIImage getImage() {
        return this.image;
    }

    public void setImage(UIImage image) {
        this.image = image;
        ((Shell)this.getControl()).setImage(this.image != null ? ((SWTImage)this.image).getHandle() : null);
    }

    public UIMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setMenuBar(UIMenuBar menuBar) {
        this.menuBar = menuBar;
        ((Shell)this.getControl()).setMenuBar(this.menuBar != null ? (Menu)((SWTMenu)this.menuBar).getControl() : null);
    }

    public void open() {
        ((Shell)this.getControl()).open();
    }

    public void close() {
        ((Shell)this.getControl()).close();
    }

    @Override
    public void setBounds(UIRectangle bounds) {
        this.resizeListener.setBounds(bounds);
        super.setBounds(bounds);
    }

    public void join() {
        while (!((Shell)this.getControl()).isDisposed() && !((Shell)this.getControl()).getDisplay().isDisposed()) {
            if (((Shell)this.getControl()).getDisplay().readAndDispatch()) continue;
            ((Shell)this.getControl()).getDisplay().sleep();
        }
    }

    public void minimize() {
        if ((((Shell)this.getControl()).getStyle() & 0x80) != 0) {
            ((Shell)this.getControl()).setMinimized(true);
        }
    }

    public void maximize() {
        if ((((Shell)this.getControl()).getStyle() & 0x400) != 0) {
            ((Shell)this.getControl()).setMaximized(true);
        }
    }

    public boolean isMaximized() {
        return ((Shell)this.getControl()).getMaximized();
    }

    public void moveToTop() {
        ((Shell)this.getControl()).setMinimized(false);
        ((Shell)this.getControl()).forceActive();
    }

    public void addCloseListener(UICloseListener listener) {
        if (this.closeListener.isEmpty()) {
            ((Shell)this.getControl()).addShellListener((ShellListener)this.closeListener);
        }
        this.closeListener.addListener(listener);
    }

    public void removeCloseListener(UICloseListener listener) {
        this.closeListener.removeListener(listener);
        if (this.closeListener.isEmpty()) {
            ((Shell)this.getControl()).removeShellListener((ShellListener)this.closeListener);
        }
    }

    private class SWTWindowResizeListener
    implements Listener {
        private UIRectangle bounds;
        private SWTWindow window;

        public SWTWindowResizeListener(SWTWindow window) {
            this.window = window;
        }

        public void handleEvent(Event e) {
            UIRectangle bounds = this.window.getBounds();
            if (this.bounds == null || !this.bounds.equals((Object)bounds)) {
                this.bounds = bounds;
                this.window.layout();
            }
        }

        public void setBounds(UIRectangle bounds) {
            this.bounds = bounds;
        }
    }
}

