/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.sequencer;

import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.impl.jsa.message.MidiShortMessage;
import org.herac.tuxguitar.player.impl.jsa.sequencer.MidiSequencerImpl;

public class MidiReceiverImpl
implements Receiver {
    private MidiSequencerImpl sequencer;

    public MidiReceiverImpl(MidiSequencerImpl sequencer) {
        this.sequencer = sequencer;
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        try {
            if (this.sequencer.isRunning()) {
                this.parseMessage(message);
            }
        }
        catch (MidiPlayerException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
    }

    private void parseMessage(MidiMessage message) throws MidiPlayerException {
        byte[] data = message.getMessage();
        if (data.length > 0) {
            if ((data[0] & 0xFF & 0xF0) == 144) {
                this.parseNoteOn(data, this.findChannel(message), this.findVoice(message), this.findBendMode(message));
            } else if ((data[0] & 0xFF & 0xF0) == 128) {
                this.parseNoteOff(data, this.findChannel(message), this.findVoice(message), this.findBendMode(message));
            } else if ((data[0] & 0xFF & 0xF0) == 224) {
                this.parsePitchBend(data, this.findChannel(message), this.findVoice(message), this.findBendMode(message));
            } else if ((data[0] & 0xFF & 0xF0) == 192) {
                this.parseProgramChange(data, this.findChannel(message));
            } else if ((data[0] & 0xFF & 0xF0) == 176) {
                this.parseControlChange(data, this.findChannel(message));
            }
        }
    }

    private void parseNoteOn(byte[] data, int channel, int voice, boolean bendMode) throws MidiPlayerException {
        int velocity;
        int length = data.length;
        int value = length > 1 ? data[1] & 0xFF : 0;
        int n = velocity = length > 2 ? data[2] & 0xFF : 0;
        if (channel >= 0) {
            if (velocity == 0) {
                this.parseNoteOff(data, channel, voice, bendMode);
            } else if (value > 0) {
                this.sequencer.getTransmitter().sendNoteOn(channel, value, velocity, voice, bendMode);
            }
        }
    }

    private void parseNoteOff(byte[] data, int channel, int voice, boolean bendMode) throws MidiPlayerException {
        int velocity;
        int length = data.length;
        int value = length > 1 ? data[1] & 0xFF : 0;
        int n = velocity = length > 2 ? data[2] & 0xFF : 0;
        if (channel >= 0) {
            this.sequencer.getTransmitter().sendNoteOff(channel, value, velocity, voice, bendMode);
        }
    }

    private void parsePitchBend(byte[] data, int channel, int voice, boolean bendMode) throws MidiPlayerException {
        int value;
        int length = data.length;
        int n = value = length > 2 ? data[2] & 0xFF : -1;
        if (channel != -1 && value != -1) {
            this.sequencer.getTransmitter().sendPitchBend(channel, value, voice, bendMode);
        }
    }

    private void parseProgramChange(byte[] data, int channel) throws MidiPlayerException {
        int instrument;
        int length = data.length;
        int n = instrument = length > 1 ? data[1] & 0xFF : -1;
        if (channel != -1 && instrument != -1) {
            this.sequencer.getTransmitter().sendProgramChange(channel, instrument);
        }
    }

    private void parseControlChange(byte[] data, int channel) throws MidiPlayerException {
        int value;
        int length = data.length;
        int control = length > 1 ? data[1] & 0xFF : -1;
        int n = value = length > 2 ? data[2] & 0xFF : -1;
        if (channel != -1 && control != -1 && value != -1) {
            this.sequencer.getTransmitter().sendControlChange(channel, control, value);
        }
    }

    private int findChannel(MidiMessage midiMessage) {
        if (midiMessage instanceof MidiShortMessage) {
            return ((MidiShortMessage)midiMessage).getChannel();
        }
        byte[] data = midiMessage.getMessage();
        if (data != null && data.length > 0) {
            return data[0] & 0xFF & 0xF;
        }
        return -1;
    }

    private int findVoice(MidiMessage midiMessage) {
        if (midiMessage instanceof MidiShortMessage) {
            return ((MidiShortMessage)midiMessage).getVoice();
        }
        return -1;
    }

    private boolean findBendMode(MidiMessage midiMessage) {
        if (midiMessage instanceof MidiShortMessage) {
            return ((MidiShortMessage)midiMessage).isBendMode();
        }
        return false;
    }
}

