/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.models;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGNote;

public abstract class TGVoice {
    public static final int DIRECTION_NONE = 0;
    public static final int DIRECTION_UP = 1;
    public static final int DIRECTION_DOWN = 2;
    private TGBeat beat;
    private TGDuration duration;
    private List<TGNote> notes;
    private int index;
    private int direction;
    private boolean empty;

    public TGVoice(TGFactory factory, int index) {
        this.duration = factory.newDuration();
        this.notes = new ArrayList<TGNote>();
        this.index = index;
        this.empty = true;
        this.direction = 0;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public TGDuration getDuration() {
        return this.duration;
    }

    public void setDuration(TGDuration duration) {
        this.duration = duration;
    }

    public TGBeat getBeat() {
        return this.beat;
    }

    public void setBeat(TGBeat beat) {
        this.beat = beat;
    }

    public List<TGNote> getNotes() {
        return this.notes;
    }

    public void addNote(TGNote note) {
        note.setVoice(this);
        this.notes.add(note);
        this.setEmpty(false);
    }

    public void moveNote(int index, TGNote note) {
        this.getNotes().remove(note);
        this.getNotes().add(index, note);
    }

    public void removeNote(TGNote note) {
        this.notes.remove(note);
    }

    public TGNote getNote(int index) {
        if (index >= 0 && index < this.countNotes()) {
            return this.notes.get(index);
        }
        return null;
    }

    public int countNotes() {
        return this.notes.size();
    }

    public boolean isRestVoice() {
        return this.notes.isEmpty();
    }

    public TGVoice clone(TGFactory factory) {
        TGVoice voice = factory.newVoice(this.getIndex());
        voice.setEmpty(this.isEmpty());
        voice.setDirection(this.getDirection());
        voice.getDuration().copyFrom(this.getDuration());
        for (int i = 0; i < this.countNotes(); ++i) {
            TGNote note = this.notes.get(i);
            voice.addNote(note.clone(factory));
        }
        return voice;
    }
}

