/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.util.properties;

import java.util.HashMap;
import java.util.Map;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.properties.TGProperties;
import org.herac.tuxguitar.util.properties.TGPropertiesException;
import org.herac.tuxguitar.util.properties.TGPropertiesFactory;
import org.herac.tuxguitar.util.properties.TGPropertiesReader;
import org.herac.tuxguitar.util.properties.TGPropertiesWriter;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGPropertiesManager {
    private TGPropertiesFactory propertiesFactory = null;
    private Map<String, TGPropertiesReader> propertiesReaders = new HashMap<String, TGPropertiesReader>();
    private Map<String, TGPropertiesWriter> propertiesWriters = new HashMap<String, TGPropertiesWriter>();

    private TGPropertiesManager() {
    }

    public TGProperties createProperties() throws TGPropertiesException {
        if (this.propertiesFactory != null) {
            return this.propertiesFactory.createProperties();
        }
        return null;
    }

    public void readProperties(TGProperties properties, String resource, String module) {
        if (this.propertiesReaders.containsKey(resource)) {
            TGPropertiesReader tgPropertiesReader = this.propertiesReaders.get(resource);
            tgPropertiesReader.readProperties(properties, module);
        }
    }

    public void writeProperties(TGProperties properties, String resource, String module) {
        if (this.propertiesWriters.containsKey(resource)) {
            TGPropertiesWriter tgPropertiesWriter = this.propertiesWriters.get(resource);
            tgPropertiesWriter.writeProperties(properties, module);
        }
    }

    public TGPropertiesFactory getPropertiesFactory() {
        return this.propertiesFactory;
    }

    public void setPropertiesFactory(TGPropertiesFactory propertiesFactory) {
        this.propertiesFactory = propertiesFactory;
    }

    public void addPropertiesReader(String resource, TGPropertiesReader propertiesReader) {
        if (!this.propertiesReaders.containsKey(resource)) {
            this.propertiesReaders.put(resource, propertiesReader);
        }
    }

    public void removePropertiesReader(String resource) {
        if (this.propertiesReaders.containsKey(resource)) {
            this.propertiesReaders.remove(resource);
        }
    }

    public void addPropertiesWriter(String resource, TGPropertiesWriter propertiesWriter) {
        if (!this.propertiesWriters.containsKey(resource)) {
            this.propertiesWriters.put(resource, propertiesWriter);
        }
    }

    public void removePropertiesWriter(String resource) {
        if (this.propertiesWriters.containsKey(resource)) {
            this.propertiesWriters.remove(resource);
        }
    }

    public static TGPropertiesManager getInstance(TGContext context) {
        return TGSingletonUtil.getInstance(context, TGPropertiesManager.class.getName(), new TGSingletonFactory<TGPropertiesManager>(){

            @Override
            public TGPropertiesManager createInstance(TGContext context) {
                return new TGPropertiesManager();
            }
        });
    }
}

