/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.tools.browser.ftp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.tools.browser.TGBrowserCollection;
import org.herac.tuxguitar.app.tools.browser.TGBrowserManager;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserFactorySettingsHandler;
import org.herac.tuxguitar.app.tools.browser.base.TGBrowserSettings;
import org.herac.tuxguitar.app.tools.browser.ftp.TGBrowserSettingsModel;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.app.view.dialog.browser.main.TGBrowserDialog;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICheckBox;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UITextField;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

class TGBrowserDataDialog {
    private static final Float MINIMUM_LEGEND_WIDTH = Float.valueOf(350.0f);
    private TGContext context;
    private TGBrowserFactorySettingsHandler handler;

    public TGBrowserDataDialog(TGContext context, TGBrowserFactorySettingsHandler handler) {
        this.context = context;
        this.handler = handler;
    }

    public void show() {
        TGBrowserDialog browser = TGBrowserDialog.getInstance((TGContext)this.context);
        this.show(!browser.isDisposed() ? browser.getWindow() : TGWindow.getInstance((TGContext)this.context).getWindow());
    }

    public void show(final UIWindow parent) {
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(parent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty((String)"tuxguitar-browser-ftp.browser-dialog.title"));
        UITableLayout serverLayout = new UITableLayout();
        UILegendPanel server = uiFactory.createLegendPanel((UIContainer)dialog);
        server.setLayout((UILayout)serverLayout);
        server.setText(TuxGuitar.getProperty((String)"tuxguitar-browser-ftp.browser-dialog.server.settings"));
        dialogLayout.set((UIControl)server, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), MINIMUM_LEGEND_WIDTH, null, null);
        UILabel nameLabel = uiFactory.createLabel((UIContainer)server);
        nameLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-browser-ftp.browser-dialog.name"));
        serverLayout.set((UIControl)nameLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextField nameText = uiFactory.createTextField((UIContainer)server);
        serverLayout.set((UIControl)nameText, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UILabel hostLabel = uiFactory.createLabel((UIContainer)server);
        hostLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-browser-ftp.browser-dialog.host"));
        serverLayout.set((UIControl)hostLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextField hostText = uiFactory.createTextField((UIContainer)server);
        serverLayout.set((UIControl)hostText, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UILabel pathLabel = uiFactory.createLabel((UIContainer)server);
        pathLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-browser-ftp.browser-dialog.path"));
        serverLayout.set((UIControl)pathLabel, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextField pathText = uiFactory.createTextField((UIContainer)server);
        serverLayout.set((UIControl)pathText, Integer.valueOf(3), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UILabel userLabel = uiFactory.createLabel((UIContainer)server);
        userLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-browser-ftp.browser-dialog.username"));
        serverLayout.set((UIControl)userLabel, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextField userText = uiFactory.createTextField((UIContainer)server);
        serverLayout.set((UIControl)userText, Integer.valueOf(4), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UILabel passwordLabel = uiFactory.createLabel((UIContainer)server);
        passwordLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-browser-ftp.browser-dialog.password"));
        serverLayout.set((UIControl)passwordLabel, Integer.valueOf(5), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextField passwordText = uiFactory.createTextField((UIContainer)server);
        serverLayout.set((UIControl)passwordText, Integer.valueOf(5), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UITableLayout proxyLayout = new UITableLayout();
        UILegendPanel proxy = uiFactory.createLegendPanel((UIContainer)dialog);
        proxy.setLayout((UILayout)proxyLayout);
        proxy.setText(TuxGuitar.getProperty((String)"tuxguitar-browser-ftp.browser-dialog.proxy.settings"));
        dialogLayout.set((UIControl)proxy, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), MINIMUM_LEGEND_WIDTH, null, null);
        final UICheckBox hasProxy = uiFactory.createCheckBox((UIContainer)proxy);
        hasProxy.setText(TuxGuitar.getProperty((String)"tuxguitar-browser-ftp.browser-dialog.proxy.enabled"));
        proxyLayout.set((UIControl)hasProxy, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2));
        UILabel proxyHostLabel = uiFactory.createLabel((UIContainer)proxy);
        proxyHostLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-browser-ftp.browser-dialog.proxy.host"));
        proxyLayout.set((UIControl)proxyHostLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextField proxyHostText = uiFactory.createTextField((UIContainer)proxy);
        proxyLayout.set((UIControl)proxyHostText, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UILabel proxyPortLabel = uiFactory.createLabel((UIContainer)proxy);
        proxyPortLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-browser-ftp.browser-dialog.proxy.port"));
        proxyLayout.set((UIControl)proxyPortLabel, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextField proxyPortText = uiFactory.createTextField((UIContainer)proxy);
        proxyPortText.setText("1080");
        proxyLayout.set((UIControl)proxyPortText, Integer.valueOf(3), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UILabel proxyUserLabel = uiFactory.createLabel((UIContainer)proxy);
        proxyUserLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-browser-ftp.browser-dialog.proxy.username"));
        proxyLayout.set((UIControl)proxyUserLabel, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextField proxyUserText = uiFactory.createTextField((UIContainer)proxy);
        proxyLayout.set((UIControl)proxyUserText, Integer.valueOf(4), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        UILabel proxyPwdLabel = uiFactory.createLabel((UIContainer)proxy);
        proxyPwdLabel.setText(TuxGuitar.getProperty((String)"tuxguitar-browser-ftp.browser-dialog.proxy.password"));
        proxyLayout.set((UIControl)proxyPwdLabel, Integer.valueOf(5), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UITextField proxyPwdText = uiFactory.createTextField((UIContainer)proxy);
        proxyLayout.set((UIControl)proxyPwdText, Integer.valueOf(5), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        proxyHostText.setEnabled(false);
        proxyPortText.setEnabled(false);
        proxyUserText.setEnabled(false);
        proxyPwdText.setEnabled(false);
        hasProxy.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                proxyHostText.setEnabled(hasProxy.isSelected());
                proxyPortText.setEnabled(hasProxy.isSelected());
                proxyUserText.setEnabled(hasProxy.isSelected());
                proxyPwdText.setEnabled(hasProxy.isSelected());
            }
        });
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                String name = nameText.getText();
                String host = hostText.getText();
                String path = pathText.getText();
                String user = userText.getText();
                String password = passwordText.getText();
                String proxyHost = proxyHostText.getText();
                String proxyPortStr = proxyPortText.getText();
                String proxyUser = proxyUserText.getText();
                String proxyPwd = proxyPwdText.getText();
                List<String> errors = TGBrowserDataDialog.this.validate(name, host, proxyHost, proxyPortStr, hasProxy.isSelected());
                if (!errors.isEmpty()) {
                    StringWriter buffer = new StringWriter();
                    PrintWriter writer = new PrintWriter(buffer);
                    Iterator<String> it = errors.iterator();
                    while (it.hasNext()) {
                        writer.println("*" + it.next());
                    }
                    TGMessageDialogUtil.errorMessage((TGContext)TGBrowserDataDialog.this.getContext(), (UIWindow)parent, (String)buffer.getBuffer().toString());
                } else {
                    int proxyPort = Integer.parseInt(proxyPortStr);
                    dialog.dispose();
                    TGBrowserSettings settings = new TGBrowserSettingsModel(name, host, path, user, password, proxyUser, proxyPwd, proxyHost, proxyPort).toBrowserSettings();
                    TGBrowserDataDialog.this.handler.onCreateSettings(settings);
                }
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog((UIWindow)dialog, (int)5);
    }

    public List<String> validate(String name, String host, String pHost, String pPort, boolean pEnabled) {
        ArrayList<String> errors = new ArrayList<String>();
        if (name == null || name.trim().length() == 0) {
            errors.add("Please enter the Name");
        } else {
            Iterator it = TGBrowserManager.getInstance((TGContext)this.getContext()).getCollections();
            while (it.hasNext()) {
                TGBrowserCollection collection = (TGBrowserCollection)it.next();
                if (!name.equals(collection.getData().getTitle())) continue;
                errors.add("A collection named \"" + name + "\" already exists");
                break;
            }
        }
        if (host == null || host.trim().length() == 0) {
            errors.add("Please enter the Host");
        }
        if (pEnabled) {
            if (pHost == null || pHost.trim().length() == 0) {
                errors.add("Please enter Proxy Host");
            }
            if (pPort == null || pPort.trim().length() == 0) {
                errors.add("Please enter Proxy Port");
            } else if (!this.isNumber(pPort)) {
                errors.add("Proxy Port should be a valid number");
            }
        }
        return errors;
    }

    public boolean isNumber(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public TGContext getContext() {
        return this.context;
    }
}

