///////////////////////////////////////////////////////////////////////////////
//
//  AutobahnJS - http://autobahn.ws, http://wamp.ws
//
//  A JavaScript library for WAMP ("The Web Application Messaging Protocol").
//
//  Copyright (c) Crossbar.io Technologies GmbH and contributors
//
//  Licensed under the MIT License.
//  http://www.opensource.org/licenses/mit-license.php
//
///////////////////////////////////////////////////////////////////////////////

// require('assert') would be nice .. but it does not
// work with Google Closure after Browserify

var crypto = require('crypto-js');

// PBKDF2-base key derivation function for salted WAMP-CRA
//
function derive_key (secret, salt, iterations, keylen) {
   var iterations = iterations || 1000;
   var keylen = keylen || 32;
   var config = {
      keySize: keylen / 4,
      iterations: iterations,
      hasher: crypto.algo.SHA256
   }
   var key = crypto.PBKDF2(secret, salt, config);
   return key.toString(crypto.enc.Base64);
}


function sign (key, challenge) {
   return crypto.HmacSHA256(challenge, key).toString(crypto.enc.Base64);
}

exports.sign = sign;
exports.derive_key = derive_key;
