import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import { IotHubGatewayServiceAPIsContext } from "../iotHubGatewayServiceAPIsContext";
/** Class representing a DigitalTwin. */
export declare class DigitalTwin {
    private readonly client;
    /**
     * Create a DigitalTwin.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    constructor(client: IotHubGatewayServiceAPIsContext);
    /**
     * @summary Gets a digital twin.
     * @param id Digital Twin ID.
     * @param [options] The optional parameters
     * @returns Promise<Models.DigitalTwinGetDigitalTwinResponse>
     */
    getDigitalTwin(id: string, options?: msRest.RequestOptionsBase): Promise<Models.DigitalTwinGetDigitalTwinResponse>;
    /**
     * @param id Digital Twin ID.
     * @param callback The callback
     */
    getDigitalTwin(id: string, callback: msRest.ServiceCallback<any>): void;
    /**
     * @param id Digital Twin ID.
     * @param options The optional parameters
     * @param callback The callback
     */
    getDigitalTwin(id: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<any>): void;
    /**
     * @summary Updates a digital twin.
     * @param id Digital Twin ID.
     * @param digitalTwinPatch json-patch contents to update.
     * @param [options] The optional parameters
     * @returns Promise<Models.DigitalTwinUpdateDigitalTwinResponse>
     */
    updateDigitalTwin(id: string, digitalTwinPatch: any[], options?: Models.DigitalTwinUpdateDigitalTwinOptionalParams): Promise<Models.DigitalTwinUpdateDigitalTwinResponse>;
    /**
     * @param id Digital Twin ID.
     * @param digitalTwinPatch json-patch contents to update.
     * @param callback The callback
     */
    updateDigitalTwin(id: string, digitalTwinPatch: any[], callback: msRest.ServiceCallback<void>): void;
    /**
     * @param id Digital Twin ID.
     * @param digitalTwinPatch json-patch contents to update.
     * @param options The optional parameters
     * @param callback The callback
     */
    updateDigitalTwin(id: string, digitalTwinPatch: any[], options: Models.DigitalTwinUpdateDigitalTwinOptionalParams, callback: msRest.ServiceCallback<void>): void;
    /**
     * Invoke a digital twin root level command.
     * @summary Invoke a digital twin root level command.
     * @param id
     * @param commandName
     * @param payload
     * @param [options] The optional parameters
     * @returns Promise<Models.DigitalTwinInvokeRootLevelCommandResponse>
     */
    invokeRootLevelCommand(id: string, commandName: string, payload: any, options?: Models.DigitalTwinInvokeRootLevelCommandOptionalParams): Promise<Models.DigitalTwinInvokeRootLevelCommandResponse>;
    /**
     * @param id
     * @param commandName
     * @param payload
     * @param callback The callback
     */
    invokeRootLevelCommand(id: string, commandName: string, payload: any, callback: msRest.ServiceCallback<any>): void;
    /**
     * @param id
     * @param commandName
     * @param payload
     * @param options The optional parameters
     * @param callback The callback
     */
    invokeRootLevelCommand(id: string, commandName: string, payload: any, options: Models.DigitalTwinInvokeRootLevelCommandOptionalParams, callback: msRest.ServiceCallback<any>): void;
    /**
     * Invoke a digital twin command.
     * @summary Invoke a digital twin command.
     * @param id
     * @param componentPath
     * @param commandName
     * @param payload
     * @param [options] The optional parameters
     * @returns Promise<Models.DigitalTwinInvokeComponentCommandResponse>
     */
    invokeComponentCommand(id: string, componentPath: string, commandName: string, payload: any, options?: Models.DigitalTwinInvokeComponentCommandOptionalParams): Promise<Models.DigitalTwinInvokeComponentCommandResponse>;
    /**
     * @param id
     * @param componentPath
     * @param commandName
     * @param payload
     * @param callback The callback
     */
    invokeComponentCommand(id: string, componentPath: string, commandName: string, payload: any, callback: msRest.ServiceCallback<any>): void;
    /**
     * @param id
     * @param componentPath
     * @param commandName
     * @param payload
     * @param options The optional parameters
     * @param callback The callback
     */
    invokeComponentCommand(id: string, componentPath: string, commandName: string, payload: any, options: Models.DigitalTwinInvokeComponentCommandOptionalParams, callback: msRest.ServiceCallback<any>): void;
}
