import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import { IotHubGatewayServiceAPIsContext } from "../iotHubGatewayServiceAPIsContext";
/** Class representing a Query. */
export declare class Query {
    private readonly client;
    /**
     * Create a Query.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    constructor(client: IotHubGatewayServiceAPIsContext);
    /**
     * Query an IoT Hub to retrieve information regarding device twins using a SQL-like language. See
     * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language for more information.
     * Pagination is supported. This returns information about device twins only.
     * @param querySpecification The query string. See
     * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language for more information.
     * @param [options] The optional parameters
     * @returns Promise<Models.QueryGetTwinsResponse>
     */
    getTwins(querySpecification: Models.QuerySpecification, options?: Models.QueryGetTwinsOptionalParams): Promise<Models.QueryGetTwinsResponse>;
    /**
     * @param querySpecification The query string. See
     * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language for more information.
     * @param callback The callback
     */
    getTwins(querySpecification: Models.QuerySpecification, callback: msRest.ServiceCallback<Models.Twin[]>): void;
    /**
     * @param querySpecification The query string. See
     * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language for more information.
     * @param options The optional parameters
     * @param callback The callback
     */
    getTwins(querySpecification: Models.QuerySpecification, options: Models.QueryGetTwinsOptionalParams, callback: msRest.ServiceCallback<Models.Twin[]>): void;
}
