import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import { IotHubGatewayServiceAPIsContext } from "../iotHubGatewayServiceAPIsContext";
/** Class representing a BulkRegistry. */
export declare class BulkRegistry {
    private readonly client;
    /**
     * Create a BulkRegistry.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    constructor(client: IotHubGatewayServiceAPIsContext);
    /**
     * Creates, updates, or deletes the identities of multiple devices from the IoT Hub identity
     * registry. A device identity can be specified only once in the list. Different operations
     * (create, update, delete) on different devices are allowed. A maximum of 100 devices can be
     * specified per invocation. For large scale operations, use the import feature using blob storage
     * (https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities).
     * @param devices The registry operations to perform.
     * @param [options] The optional parameters
     * @returns Promise<Models.BulkRegistryUpdateRegistryResponse>
     */
    updateRegistry(devices: Models.ExportImportDevice[], options?: msRest.RequestOptionsBase): Promise<Models.BulkRegistryUpdateRegistryResponse>;
    /**
     * @param devices The registry operations to perform.
     * @param callback The callback
     */
    updateRegistry(devices: Models.ExportImportDevice[], callback: msRest.ServiceCallback<Models.BulkRegistryOperationResult>): void;
    /**
     * @param devices The registry operations to perform.
     * @param options The optional parameters
     * @param callback The callback
     */
    updateRegistry(devices: Models.ExportImportDevice[], options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.BulkRegistryOperationResult>): void;
}
