"use strict";
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DigitalTwin = void 0;
const msRest = require("@azure/ms-rest-js");
const Mappers = require("../models/digitalTwinMappers");
const Parameters = require("../models/parameters");
/** Class representing a DigitalTwin. */
class DigitalTwin {
    /**
     * Create a DigitalTwin.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    constructor(client) {
        this.client = client;
    }
    getDigitalTwin(id, options, callback) {
        return this.client.sendOperationRequest({
            id,
            options
        }, getDigitalTwinOperationSpec, callback);
    }
    updateDigitalTwin(id, digitalTwinPatch, options, callback) {
        return this.client.sendOperationRequest({
            id,
            digitalTwinPatch,
            options
        }, updateDigitalTwinOperationSpec, callback);
    }
    invokeRootLevelCommand(id, commandName, payload, options, callback) {
        return this.client.sendOperationRequest({
            id,
            commandName,
            payload,
            options
        }, invokeRootLevelCommandOperationSpec, callback);
    }
    invokeComponentCommand(id, componentPath, commandName, payload, options, callback) {
        return this.client.sendOperationRequest({
            id,
            componentPath,
            commandName,
            payload,
            options
        }, invokeComponentCommandOperationSpec, callback);
    }
}
exports.DigitalTwin = DigitalTwin;
// Operation Specifications
const serializer = new msRest.Serializer(Mappers);
const getDigitalTwinOperationSpec = {
    httpMethod: "GET",
    path: "digitaltwins/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Object"
                }
            },
            headersMapper: Mappers.DigitalTwinGetDigitalTwinHeaders
        },
        default: {}
    },
    serializer
};
const updateDigitalTwinOperationSpec = {
    httpMethod: "PATCH",
    path: "digitaltwins/{id}",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    requestBody: {
        parameterPath: "digitalTwinPatch",
        mapper: {
            required: true,
            serializedName: "digitalTwinPatch",
            type: {
                name: "Sequence",
                element: {
                    type: {
                        name: "Object"
                    }
                }
            }
        }
    },
    responses: {
        202: {
            headersMapper: Mappers.DigitalTwinUpdateDigitalTwinHeaders
        },
        default: {}
    },
    serializer
};
const invokeRootLevelCommandOperationSpec = {
    httpMethod: "POST",
    path: "digitaltwins/{id}/commands/{commandName}",
    urlParameters: [
        Parameters.id,
        Parameters.commandName
    ],
    queryParameters: [
        Parameters.apiVersion,
        Parameters.connectTimeoutInSeconds,
        Parameters.responseTimeoutInSeconds
    ],
    requestBody: {
        parameterPath: "payload",
        mapper: {
            required: true,
            serializedName: "payload",
            type: {
                name: "Object"
            }
        }
    },
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Object"
                }
            },
            headersMapper: Mappers.DigitalTwinInvokeRootLevelCommandHeaders
        },
        default: {}
    },
    serializer
};
const invokeComponentCommandOperationSpec = {
    httpMethod: "POST",
    path: "digitaltwins/{id}/components/{componentPath}/commands/{commandName}",
    urlParameters: [
        Parameters.id,
        Parameters.componentPath,
        Parameters.commandName
    ],
    queryParameters: [
        Parameters.apiVersion,
        Parameters.connectTimeoutInSeconds,
        Parameters.responseTimeoutInSeconds
    ],
    requestBody: {
        parameterPath: "payload",
        mapper: {
            required: true,
            serializedName: "payload",
            type: {
                name: "Object"
            }
        }
    },
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Object"
                }
            },
            headersMapper: Mappers.DigitalTwinInvokeComponentCommandHeaders
        },
        default: {}
    },
    serializer
};
//# sourceMappingURL=digitalTwin.js.map