/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import * as Mappers from "../models/configurationOperationsMappers";
import * as Parameters from "../models/parameters";
import { IotHubGatewayServiceAPIsContext } from "../iotHubGatewayServiceAPIsContext";

/** Class representing a ConfigurationOperations. */
export class ConfigurationOperations {
  private readonly client: IotHubGatewayServiceAPIsContext;

  /**
   * Create a ConfigurationOperations.
   * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
   */
  constructor(client: IotHubGatewayServiceAPIsContext) {
    this.client = client;
  }

  /**
   * Gets a configuration on the IoT Hub for automatic device/module management.
   * @param id The unique identifier of the configuration.
   * @param [options] The optional parameters
   * @returns Promise<Models.ConfigurationGetResponse>
   */
  get(id: string, options?: msRest.RequestOptionsBase): Promise<Models.ConfigurationGetResponse>;
  /**
   * @param id The unique identifier of the configuration.
   * @param callback The callback
   */
  get(id: string, callback: msRest.ServiceCallback<Models.Configuration>): void;
  /**
   * @param id The unique identifier of the configuration.
   * @param options The optional parameters
   * @param callback The callback
   */
  get(id: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.Configuration>): void;
  get(id: string, options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.Configuration>, callback?: msRest.ServiceCallback<Models.Configuration>): Promise<Models.ConfigurationGetResponse> {
    return this.client.sendOperationRequest(
      {
        id,
        options
      },
      getOperationSpec,
      callback) as Promise<Models.ConfigurationGetResponse>;
  }

  /**
   * Creates or updates a configuration on the IoT Hub for automatic device/module management.
   * Configuration identifier and Content cannot be updated.
   * @param id The unique identifier of the configuration.
   * @param configuration The configuration to be created or updated.
   * @param [options] The optional parameters
   * @returns Promise<Models.ConfigurationCreateOrUpdateResponse>
   */
  createOrUpdate(id: string, configuration: Models.Configuration, options?: Models.ConfigurationCreateOrUpdateOptionalParams): Promise<Models.ConfigurationCreateOrUpdateResponse>;
  /**
   * @param id The unique identifier of the configuration.
   * @param configuration The configuration to be created or updated.
   * @param callback The callback
   */
  createOrUpdate(id: string, configuration: Models.Configuration, callback: msRest.ServiceCallback<Models.Configuration>): void;
  /**
   * @param id The unique identifier of the configuration.
   * @param configuration The configuration to be created or updated.
   * @param options The optional parameters
   * @param callback The callback
   */
  createOrUpdate(id: string, configuration: Models.Configuration, options: Models.ConfigurationCreateOrUpdateOptionalParams, callback: msRest.ServiceCallback<Models.Configuration>): void;
  createOrUpdate(id: string, configuration: Models.Configuration, options?: Models.ConfigurationCreateOrUpdateOptionalParams | msRest.ServiceCallback<Models.Configuration>, callback?: msRest.ServiceCallback<Models.Configuration>): Promise<Models.ConfigurationCreateOrUpdateResponse> {
    return this.client.sendOperationRequest(
      {
        id,
        configuration,
        options
      },
      createOrUpdateOperationSpec,
      callback) as Promise<Models.ConfigurationCreateOrUpdateResponse>;
  }

  /**
   * Deletes a configuration on the IoT Hub for automatic device/module management.
   * @param id The unique identifier of the configuration.
   * @param [options] The optional parameters
   * @returns Promise<msRest.RestResponse>
   */
  deleteMethod(id: string, options?: Models.ConfigurationDeleteMethodOptionalParams): Promise<msRest.RestResponse>;
  /**
   * @param id The unique identifier of the configuration.
   * @param callback The callback
   */
  deleteMethod(id: string, callback: msRest.ServiceCallback<void>): void;
  /**
   * @param id The unique identifier of the configuration.
   * @param options The optional parameters
   * @param callback The callback
   */
  deleteMethod(id: string, options: Models.ConfigurationDeleteMethodOptionalParams, callback: msRest.ServiceCallback<void>): void;
  deleteMethod(id: string, options?: Models.ConfigurationDeleteMethodOptionalParams | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<msRest.RestResponse> {
    return this.client.sendOperationRequest(
      {
        id,
        options
      },
      deleteMethodOperationSpec,
      callback);
  }

  /**
   * Gets configurations on the IoT Hub for automatic device/module management. Pagination is not
   * supported.
   * @param [options] The optional parameters
   * @returns Promise<Models.ConfigurationGetConfigurationsResponse>
   */
  getConfigurations(options?: Models.ConfigurationGetConfigurationsOptionalParams): Promise<Models.ConfigurationGetConfigurationsResponse>;
  /**
   * @param callback The callback
   */
  getConfigurations(callback: msRest.ServiceCallback<Models.Configuration[]>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  getConfigurations(options: Models.ConfigurationGetConfigurationsOptionalParams, callback: msRest.ServiceCallback<Models.Configuration[]>): void;
  getConfigurations(options?: Models.ConfigurationGetConfigurationsOptionalParams | msRest.ServiceCallback<Models.Configuration[]>, callback?: msRest.ServiceCallback<Models.Configuration[]>): Promise<Models.ConfigurationGetConfigurationsResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      getConfigurationsOperationSpec,
      callback) as Promise<Models.ConfigurationGetConfigurationsResponse>;
  }

  /**
   * Validates target condition and custom metric queries for a configuration on the IoT Hub.
   * @param input The configuration for target condition and custom metric queries.
   * @param [options] The optional parameters
   * @returns Promise<Models.ConfigurationTestQueriesResponse>
   */
  testQueries(input: Models.ConfigurationQueriesTestInput, options?: msRest.RequestOptionsBase): Promise<Models.ConfigurationTestQueriesResponse>;
  /**
   * @param input The configuration for target condition and custom metric queries.
   * @param callback The callback
   */
  testQueries(input: Models.ConfigurationQueriesTestInput, callback: msRest.ServiceCallback<Models.ConfigurationQueriesTestResponse>): void;
  /**
   * @param input The configuration for target condition and custom metric queries.
   * @param options The optional parameters
   * @param callback The callback
   */
  testQueries(input: Models.ConfigurationQueriesTestInput, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.ConfigurationQueriesTestResponse>): void;
  testQueries(input: Models.ConfigurationQueriesTestInput, options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.ConfigurationQueriesTestResponse>, callback?: msRest.ServiceCallback<Models.ConfigurationQueriesTestResponse>): Promise<Models.ConfigurationTestQueriesResponse> {
    return this.client.sendOperationRequest(
      {
        input,
        options
      },
      testQueriesOperationSpec,
      callback) as Promise<Models.ConfigurationTestQueriesResponse>;
  }

  /**
   * Applies the configuration content to an edge device.
   * @param id The unique identifier of the edge device.
   * @param content The configuration content.
   * @param [options] The optional parameters
   * @returns Promise<msRest.RestResponse>
   */
  applyOnEdgeDevice(id: string, content: Models.ConfigurationContent, options?: msRest.RequestOptionsBase): Promise<msRest.RestResponse>;
  /**
   * @param id The unique identifier of the edge device.
   * @param content The configuration content.
   * @param callback The callback
   */
  applyOnEdgeDevice(id: string, content: Models.ConfigurationContent, callback: msRest.ServiceCallback<void>): void;
  /**
   * @param id The unique identifier of the edge device.
   * @param content The configuration content.
   * @param options The optional parameters
   * @param callback The callback
   */
  applyOnEdgeDevice(id: string, content: Models.ConfigurationContent, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<void>): void;
  applyOnEdgeDevice(id: string, content: Models.ConfigurationContent, options?: msRest.RequestOptionsBase | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<msRest.RestResponse> {
    return this.client.sendOperationRequest(
      {
        id,
        content,
        options
      },
      applyOnEdgeDeviceOperationSpec,
      callback);
  }
}

// Operation Specifications
const serializer = new msRest.Serializer(Mappers);
const getOperationSpec: msRest.OperationSpec = {
  httpMethod: "GET",
  path: "configurations/{id}",
  urlParameters: [
    Parameters.id
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  responses: {
    200: {
      bodyMapper: Mappers.Configuration
    },
    default: {}
  },
  serializer
};

const createOrUpdateOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "configurations/{id}",
  urlParameters: [
    Parameters.id
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  headerParameters: [
    Parameters.ifMatch
  ],
  requestBody: {
    parameterPath: "configuration",
    mapper: {
      ...Mappers.Configuration,
      required: true
    }
  },
  responses: {
    200: {
      bodyMapper: Mappers.Configuration
    },
    201: {
      bodyMapper: Mappers.Configuration
    },
    default: {}
  },
  serializer
};

const deleteMethodOperationSpec: msRest.OperationSpec = {
  httpMethod: "DELETE",
  path: "configurations/{id}",
  urlParameters: [
    Parameters.id
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  headerParameters: [
    Parameters.ifMatch
  ],
  responses: {
    204: {},
    default: {}
  },
  serializer
};

const getConfigurationsOperationSpec: msRest.OperationSpec = {
  httpMethod: "GET",
  path: "configurations",
  queryParameters: [
    Parameters.top,
    Parameters.apiVersion
  ],
  responses: {
    200: {
      bodyMapper: {
        serializedName: "parsedResponse",
        type: {
          name: "Sequence",
          element: {
            type: {
              name: "Composite",
              className: "Configuration"
            }
          }
        }
      }
    },
    default: {}
  },
  serializer
};

const testQueriesOperationSpec: msRest.OperationSpec = {
  httpMethod: "POST",
  path: "configurations/testQueries",
  queryParameters: [
    Parameters.apiVersion
  ],
  requestBody: {
    parameterPath: "input",
    mapper: {
      ...Mappers.ConfigurationQueriesTestInput,
      required: true
    }
  },
  responses: {
    200: {
      bodyMapper: Mappers.ConfigurationQueriesTestResponse
    },
    default: {}
  },
  serializer
};

const applyOnEdgeDeviceOperationSpec: msRest.OperationSpec = {
  httpMethod: "POST",
  path: "devices/{id}/applyConfigurationContent",
  urlParameters: [
    Parameters.id
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  requestBody: {
    parameterPath: "content",
    mapper: {
      ...Mappers.ConfigurationContent,
      required: true
    }
  },
  responses: {
    204: {},
    default: {}
  },
  serializer
};
