# 结构化数据API说明

## 结构化数据API简要说明

结构化数据API包括table操作API和record操作API。

* Table操作API：

是由开发者在使用结构化数据API开发应用时调用，包括创建、修改、删除、查看表信息及恢复表等接口； 

* Record操作API：

即数据操作API，是由最终用户在使用基于PCS结构化数据API开发的应用时触发，第三方应用通过使用用户身份（以Access Token认证）在服务器端对用户数据进行增加、删除、修改、查询等系列操作。

## 结构化数据基本概念

1. 表（table）

结构化数据以表为单位组织用户数据；表名和表中的索引由开发者定义。

2. 表名（tablename）

表的名字。表名可以由字母和下划线组成（a-z，A-Z，0-9，'_'）, 长度为3-63个字符，必须字母开头；同一个应用中，不能重复使用同一表名。

3. 记录（record）

每一条结构化数据就是一个记录，一个表中可有多条记录。

4. 列（column）

结构中的每一个字段就是一列。列名可以由字母和下划线组成（a-z，A-Z，0-9，'_'）, 长度为1-255个字符，必须字母开头。

5. 索引（index）

在表中的某些列上创建索引，可以提高查询速度。一个表中，最多可以定义5个索引，只能定义普通索引。

6. 限额（quota）

同一个表中同一个用户最多多少条数据，现在每个用户最多10000条数据。

## 结构化数据功能列表

使用PCS结构化数据功能，可以轻松的完成应用上结构化数据的存储及同步等功能。

PCS结构化数据具有如下的特性：

* 提供Restful API；

* 数据灵活性大：定义表时，不需要完全确定表中的所有列，可以增加一列或减少一列而无需重新定义表。

* 在数据上动态增减索引：定义表时，无需完全确定所有的索引；

* 数据多端同步：结构化数据提供接口，支持数据多端同步；

* 对数据进行增加、删除、修改及查询；

* 回收站：数据删除后，10天内可以还原；

* 支持应用数据隔离：不同应用的数据可以支持物理隔离；

* 支持超大数据量：
    *  一个应用可以创建5个表；
    *  单个表没有数据总量限制；
    *  单个表中，单个用户的数据量可以达到1万条；
    *  用户数无限制。

## 结构化数据存储限制

### （1）全局限制：

每个记录的大小限制为1MB （服务器端会把记录做json_encode, 得到的大小为记录大小）；

每个应用最多只能创建5个表；

批量的insert/update/delete/restore每次最多500条；

批量的select每次最多返回10000条记录。

### （2）表级别限制（quota）：

应用上的用户在表里的条目数限制（创建表的时候，每个表都有一个default_quota，以后用户在该表上都使用此default_quota，单个用户的quota可以通过quota接口设置）。

## Record操作API说明

### （1） insert、update、delete默认都支持批量操作，但是每次批量的record个数不能超过500；

### （2） 数据操作API对用户需要保持最终一致性，即：

insert、update、delete操作不保证返回后即可select 出来，通常延迟小于1s；

update、delete操作不支持条件操作，即where子句的操作，如有需要请先select出来。

## 字段说明

### 字段定义

#### PCS结构化数据平台中，表中的字段支持如下类型：

| 字段类型 | 描述 |
| :- | :- |
| string | 字符串。 |
| int | 整型数字，64位有符号，范围为[-9223372036854775808, 9223372036854775807]，超出范围自动转为float。 |
| float | 带小数点的数字。 |
| boolean | true 或者false。 |
| array | 数组，元素可以是string/number。 |
| object | 可以是一个json 对象。 |
| null | null |

#### 说明： 

字段名必须符合以下标准:

可以是a-z、A-Z、0-9、'_'；

长度范围是[1, 255]；

必须字母开头。

### 默认字段

#### 插入的记录将会有以下默认字段：

| 字段 | 类型 | 描述 |
| :- | :- | :- |
| _key | string | 全局唯一key i string(16)。 |
| _ctime | int | record创建时间。 |
| _mtime | int | record修改时间。 |
| _isdelete | int | 是否删除。 |
