# Contributing to fbzmq
We want to make contributing to this project as easy and transparent as
possible.

## Code of Conduct
The code of conduct is described in [`CODE_OF_CONDUCT.md`](CODE_OF_CONDUCT.md)

## Our Development Process
This library is actively being used by several projects within Facebook. We
don't expect any major changes in APIs exposed by libraries, however bug
fixes, performance improvements and code maintenance is likely to happen on
regular basis. New APIs or functionalities might be added as per future needs.

## Pull Requests
We actively welcome your pull requests.

1. Fork the repo and create your branch from `master`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes.
5. Make sure your code lints.
6. If you haven't already, complete the Contributor License Agreement ("CLA").

## Contributor License Agreement ("CLA")
In order to accept your pull request, we need you to submit a CLA. You only need
to do this once to work on any of Facebook's open source projects.

Complete your CLA here: <https://code.facebook.com/cla>

## Issues
We use GitHub issues to track public bugs. Please ensure your description is
clear and has sufficient instructions to be able to reproduce the issue.

Facebook has a [bounty program](https://www.facebook.com/whitehat/) for the safe
disclosure of security bugs. In those cases, please go through the process
outlined on that page and do not file a public issue.

## Coding Style
Please try to follow the existing coding style within `fbzmq` code. For C++
code, our style is
* 2 spaces for indentation rather than tabs
* 80 character line length
* Use clang-format for formatting code

## License
By contributing to fbzmq, you agree that your contributions will be licensed
under the LICENSE file in the root directory of this source tree.
